package org.phosphoresce.dbbrowser.gui.common.window;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;

import javax.swing.WindowConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EProgressBar;
import org.phosphoresce.dbbrowser.DatabaseBrowserConstants;

/**
 * _CAOt[NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/20	Kitagawa		VK쐬
 *-->
 */
public class ProcessDialog extends EDialog {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** Xbh */
	private Thread thread;

	/** Recpl */
	private EPanel contentsPanel = null;

	/** vOXo[ */
	private EProgressBar progressbar = null;

	/** LZ{^ */
	private EButton cancelButton = null;

	/**
	 * RXgN^<br>
	 */
	private ProcessDialog() {
		super();
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param owner I[i[_CAO
	 */
	private ProcessDialog(Dialog owner) {
		super(owner, true);
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param owner I[i[t[
	 */
	private ProcessDialog(Frame owner) {
		super(owner, true);
		initialize();
	}

	/**
	 * Jn܂B<br>
	 * @param owner I[i[t[
	 * @param runnable RunnableIuWFNg
	 * @param cancelable LZ\tO
	 */
	public static void execute(Frame owner, ProcessAction runnable, boolean cancelable) {
		ProcessDialog frame = new ProcessDialog(owner);
		runnable.setFrame(frame);
		frame.thread = new Thread(runnable);
		frame.cancelButton.setEnabled(cancelable);
		frame.setVisible(true);
	}

	/**
	 * Jn܂B<br>
	 * @param owner I[i[t[
	 * @param runnable RunnableIuWFNg
	 */
	public static void execute(Frame owner, ProcessAction runnable) {
		execute(owner, runnable, true);
	}

	/**
	 * _CAO\AJn܂B<br>
	 * @param visible \tO
	 * @see java.awt.Dialog#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {
		if (visible) {
			if (thread != null) {
				thread.start();
			}
		}
		super.setVisible(visible);
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setContentPane(getContentsPanel());
		this.setTitle(DatabaseBrowserConstants.APPLICATION_TITLE);
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		this.setSize(new Dimension(480, 150));
		this.setLocationRelativeTo(getParent());
	}

	/**
	 * Recpl擾܂B<br>
	 * @return Recpl
	 */
	private EPanel getContentsPanel() {
		if (contentsPanel == null) {
			contentsPanel = new EPanel();
			contentsPanel.setLayout(null);
			contentsPanel.add(getProgressbar(), null);
			contentsPanel.add(getCancelButton(), null);
		}
		return contentsPanel;
	}

	/**
	 * vOXo[擾܂B<br>
	 * @return vOXo[
	 */
	private EProgressBar getProgressbar() {
		if (progressbar == null) {
			progressbar = new EProgressBar();
			progressbar.setBounds(new Rectangle(14, 63, 446, 14));
			progressbar.setIndeterminate(true);
		}
		return progressbar;
	}

	/**
	 * LZ{^擾܂B<br>
	 * @return LZ{^
	 */
	private EButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new EButton();
			cancelButton.setBounds(new Rectangle(194, 88, 86, 24));
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					thread.interrupt();
					thread = null;
					dispose();
				}
			});
		}
		return cancelButton;
	}
}
