package org.phosphoresce.dbbrowser;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.dbbrowser.gui.common.window.ConnectionConfigureFrame;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserFrame;

/**
 * DatabaseBrowserZbVNX<br>
 * ÕIuWFNg͑z肳ꂸAAvP[Vs̓VOCX^Xۏ؂܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserSession implements Serializable {

	/** ZtCX^X */
	private static DatabaseBrowserSession instance = null;

	/** f[^x[XڑݒIuWFNg */
	private DatabaseConfig config = null;

	/** AvP[Vʃf[^x[XZbV */
	private transient DatabaseSession commonDatabaseSession = null;

	/** AvP[Vf[^x[XZbV}bv */
	private transient Map databaseSessionMap = null;

	/** DatabaseBrowsert[CX^X */
	private transient DatabaseBrowserFrame browserFrame = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserSession() {
		super();
		databaseSessionMap = new LinkedHashMap();
	}

	/**
	 * NXCX^X擾܂B<br>
	 * @return NXCX^X
	 */
	public static DatabaseBrowserSession instance() {
		if (instance == null) {
			instance = new DatabaseBrowserSession();
		}
		return instance;
	}

	/**
	 * f[^x[Xڑ̏s܂B<br>
	 */
	public void initializeConfig() {
		ConnectionConfigureFrame configureFrame = new ConnectionConfigureFrame(browserFrame, this);
		configureFrame.setLocationRelativeTo(browserFrame);
		configureFrame.setVisible(true);
		if (config == null) {
			DatabaseBrowser.exit();
		}
	}

	/**
	 * f[^x[XڑݒIuWFNg擾܂B<br>
	 * @return f[^x[XڑݒIuWFNg
	 */
	public DatabaseConfig getConfig() {
		//if (config == null) {
		//	initializeConfig();
		//}
		return config;
	}

	/**
	 * f[^x[XڑݒIuWFNgݒ肵܂B<br>
	 * @param config f[^x[XڑݒIuWFNg
	 * @throws DatabaseSessionException Ƀf[^x[XZbVsłȂꍇɔ
	 */
	public void setConfig(DatabaseConfig config) throws DatabaseSessionException {
		this.config = config;
		disposeAllDatabaseSession();
	}

	/**
	 * AvP[Vʃf[^x[XZbV擾܂B<br>
	 * @return AvP[Vʃf[^x[XZbV
	 * @throws DatabaseSessionException Ƀf[^x[XZbV擾łȂꍇɔ
	 */
	public DatabaseSession getCommonDatabaseSession() throws DatabaseSessionException {
		if (commonDatabaseSession == null) {
			commonDatabaseSession = createNewDatabaseSession();
		}
		return commonDatabaseSession;
	}

	/**
	 * w肳ꂽL[̃f[^x[XZbV擾܂B<br>
	 * @param name f[^x[XZbVL[
	 * @return f[^x[XZbV
	 * @throws DatabaseSessionException Ƀf[^x[XZbV擾łȂꍇɔ
	 */
	public DatabaseSession getDatabaseSession(String name) throws DatabaseSessionException {
		if (!databaseSessionMap.containsKey(name)) {
			databaseSessionMap.put(name, createNewDatabaseSession());
		}
		return (DatabaseSession) databaseSessionMap.get(name);
	}

	/**
	 * Vf[^x[XZbV𐶐܂B<br>
	 * @return f[^x[XZbV
	 * @throws DatabaseSessionException Ƀf[^x[XZbV擾łȂꍇɔ
	 */
	private DatabaseSession createNewDatabaseSession() throws DatabaseSessionException {
		return new DatabaseSession(getConfig());
	}

	/**
	 * ێĂ邷ׂẴf[^x[XZbVj܂B<br>
	 * @throws DatabaseSessionException ɃZbṼN[YsȂꍇɔ
	 */
	public void disposeAllDatabaseSession() throws DatabaseSessionException {
		if (commonDatabaseSession != null) {
			commonDatabaseSession.rollback();
			commonDatabaseSession.close();
		}
		commonDatabaseSession = null;
		for (Iterator iterator = databaseSessionMap.keySet().iterator(); iterator.hasNext();) {
			String name = (String) iterator.next();
			DatabaseSession databaseSession = (DatabaseSession) databaseSessionMap.get(name);
			if (databaseSession != null) {
				databaseSession.rollback();
				databaseSession.close();
			}
		}
		databaseSessionMap.clear();
	}

	/**
	 * DatabaseBrowsert[CX^Xς݂ł邩肵܂B<br>
	 * @return DatabaseBrowsert[CX^Xς݂łꍇtrueԋp
	 */
	public boolean isInstancedBrowserFrame() {
		return browserFrame != null;
	}

	/**
	 * DatabaseBrowsert[CX^X擾܂B<br>
	 * @return DatabaseBrowsert[CX^X
	 */
	public DatabaseBrowserFrame getBrowserFrame() {
		if (browserFrame == null) {
			browserFrame = DatabaseBrowserFrame.instance();
		}
		return browserFrame;
	}

	/**
	 * DatabaseBrowsert[CX^Xݒ肵܂B<br>
	 * @param browserFrame DatabaseBrowsert[CX^X
	 */
	void setBrowserFrame(DatabaseBrowserFrame browserFrame) {
		this.browserFrame = browserFrame;
	}

	/**
	 * ZbVj^C~Oł̏s܂B<br>
	 * @throws Throwable ɔjsȂꍇɔ
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		commonDatabaseSession.close();
		super.finalize();
	}
}
