package org.phosphoresce.webcore.ext.struts.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.phosphoresce.lib.commons.util.StringUtil;
import org.phosphoresce.webcore.ext.struts.StrutsConstants;

/**
 * トークンユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public class TokenUtil implements StrutsConstants {

	/**
	 * コンストラクタ<br>
	 */
	private TokenUtil() {
		super();
	}

	/**
	 * 新しいトークン値を生成します。<br>
	 * @param seed トークン生成シード文字列
	 * @return 生成したトークン文字列
	 */
	private synchronized String generateWindowToken(String seed) {
		try {
			if (StringUtil.isEmpty(seed)) {
				return null;
			}
			long current = System.currentTimeMillis();
			byte[] now = new Long(current).toString().getBytes();
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(seed.getBytes());
			md.update(now);
			return StringUtil.toHex(md.digest());
		} catch (NoSuchAlgorithmException e) {
			return null;
		}
	}

}
