package org.phosphoresce.webcore.ext.struts.exception;

import java.io.Serializable;

import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.ext.struts.StrutsConfigNames;
import org.phosphoresce.webcore.ext.struts.action.AbstractForm;
import org.phosphoresce.webcore.ext.struts.action.ActionContext;
import org.phosphoresce.webcore.ext.struts.action.Forward;
import org.phosphoresce.webcore.ext.struts.action.MessageSet;

/**
 * セッションタイムアウト例外クラス<br>
 * <br>
 * 当クラスはアクション処理時にセッションチェックを行いセッション存在が必須であるにも関わらず、セッションが存在しなかった場合にスローされます。<br>
 * 致命的な例外ではなくアプリケーションレベルの例外として利用されます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public class StrutsSessionTimeoutException extends StrutsModuleApplicationException {

	/**
	 * コンストラクタ<br>
	 */
	public StrutsSessionTimeoutException() {
		super();
	}

	/**
	 * アプリケーションメッセージを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return アプリケーションメッセージ
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException#createApplicationMessage(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends Serializable, F extends AbstractForm<L>> MessageSet createApplicationMessage(ActionContext<L, F> actionContext) {
		MessageSet set = null;
		if (actionContext.isJSONReuqest()) {
			set = new MessageSet("FSTR00038");
		} else if (actionContext.isPopupRequest()) {
			set = new MessageSet("FSTR00038");
		} else {
			set = new MessageSet("FSTR00037");
		}
		return set;
	}

	/**
	 * 遷移用アクションフォワードを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return 遷移用アクションフォワード
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException#createActionForward(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends Serializable, F extends AbstractForm<L>> Forward createActionForward(ActionContext<L, F> actionContext) {
		Forward forward = null;
		if (actionContext.isJSONReuqest()) {
			forward = null;
		} else {
			forward = new Forward();
			forward.setPath(actionContext.getServletRequest().getServletPath() + "/" + Config.getString(StrutsConfigNames.STRUTS_ACTION_DEFAULT));
			forward.setRedirect(false);
		}
		return forward;
	}

	/**
	 * レスポンスステータスを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return レスポンスステータス(特別なステータスコードが不要であればnullを返却します)
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException#createResponseStatus(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends Serializable, F extends AbstractForm<L>> Integer createResponseStatus(ActionContext<L, F> actionContext) {
		if (Config.isEmpty(StrutsConfigNames.STRUTS_STATUS_SESSIONTIMEOUT)) {
			return null;
		} else {
			return Config.getInteger(StrutsConfigNames.STRUTS_STATUS_SESSIONTIMEOUT);
		}
	}
}
