package org.phosphoresce.webcore.ext.struts.action;

import java.io.Serializable;
import java.util.Arrays;

/**
 * アプリケーションメッセージコードバインド保持クラス<br>
 * <br>
 * 当クラスは外部文字列定義から構成されるメッセージ内容を管理するクラスです。<br>
 * メッセージコード及び、バインドされる文字列をセットで保持します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2009/12/18	Kitagawa		新規作成
 * 2012/07/06	Kitagawa		全体的に再構築
 *-->
 */
public final class MessageSet implements Serializable {

	/** メッセージコード */
	private String code;

	/** バインドオブジェクト */
	private Object[] binds;

	/** 該当明細行数 */
	private Integer rowNumber;

	/**
	 * コンストラクタ<br>
	 * @param rowNumber 該当明細行数
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 */
	public MessageSet(Integer rowNumber, String code, Object[] binds) {
		super();
		this.rowNumber = rowNumber;
		this.code = code;
		this.binds = binds;
	}

	/**
	 * コンストラクタ<br>
	 * @param rowNumber 該当明細行数
	 * @param code メッセージコード
	 */
	public MessageSet(Integer rowNumber, String code) {
		this(rowNumber, code, null);
	}

	/**
	 * コンストラクタ<br>
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 */
	public MessageSet(String code, Object[] binds) {
		this(null, code, binds);
	}

	/**
	 * コンストラクタ<br>
	 * @param code メッセージコード
	 */
	public MessageSet(String code) {
		this(null, code, null);
	}

	/**
	 * オブジェクトハッシュコードを取得します。<br>
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public final int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(binds);
		result = prime * result + ((code == null) ? 0 : code.hashCode());
		result = prime * result + ((rowNumber == null) ? 0 : rowNumber.hashCode());
		return result;
	}

	/**
	 * オブジェクトの等価比較を行います。<br>
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public final boolean equals(Object object) {
		if (this == object)
			return true;
		if (object == null)
			return false;
		if (getClass() != object.getClass())
			return false;
		MessageSet other = (MessageSet) object;
		if (!Arrays.equals(binds, other.binds))
			return false;
		if (code == null) {
			if (other.code != null)
				return false;
		} else if (!code.equals(other.code))
			return false;
		if (rowNumber == null) {
			if (other.rowNumber != null)
				return false;
		} else if (!rowNumber.equals(other.rowNumber))
			return false;
		return true;
	}

	/**
	 * メッセージコードを取得します。<br>
	 * @return メッセージコード
	 */
	public final String getCode() {
		return code;
	}

	/**
	 * バインドオブジェクトを取得します。<br>
	 * @return バインドオブジェクト
	 */
	public final Object[] getBinds() {
		return binds;
	}

	/**
	 * 該当明細行数を取得します。<br>
	 * @return 該当明細行数
	 */
	public final Integer getRowNumber() {
		return rowNumber;
	}
}
