package org.phosphoresce.webcore.ext.struts.action;

import java.io.Serializable;
import java.util.Date;

/**
 * ログインユーザー情報<br>
 * <br>
 * 当クラスはフレームワークモジュール共通の基本ログインユーザ情報を保持します。<br>
 * アプリケーション固有のログイン情報を持つ必要がある場合はloginInfoフィールドに情報を設定して利用します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/05	Kitagawa		全体的に再構築
 *-->
 */
public final class LoginUser<L extends Serializable> implements Serializable {

	/** ユーザコード */
	private String userCode;

	/** ログイン日時 */
	private Date loginDate;

	/** ログイン情報 */
	private L loginInfo;

	/**
	 * コンストラクタ<br>
	 */
	public LoginUser() {
		super();
	}

	/**
	 * ユーザコードを取得します。<br>
	 * @return ユーザコード
	 */
	public String getUserCode() {
		return userCode;
	}

	/**
	 * ユーザコードを設定します。<br>
	 * @param userCode ユーザコード
	 */
	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	/**
	 * ログイン日時を取得します。<br>
	 * @return ログイン日時
	 */
	public Date getLoginDate() {
		return loginDate;
	}

	/**
	 * ログイン日時を設定します。<br>
	 * @param loginDate ログイン日時
	 */
	public void setLoginDate(Date loginDate) {
		this.loginDate = loginDate;
	}

	/**
	 * ログイン情報を取得します。<br>
	 * @return ログイン情報
	 */
	public L getLoginInfo() {
		return loginInfo;
	}

	/**
	 * ログイン情報を設定します。<br>
	 * @param loginInfo ログイン情報
	 */
	public void setLoginInfo(L loginInfo) {
		this.loginInfo = loginInfo;
	}

	/**
	 * クラス情報を文字列で取得します。<br>
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("{");
		builder.append("userCode=");
		builder.append(userCode);
		builder.append(", ");
		builder.append("loginDate=");
		builder.append(loginDate);
		builder.append(", ");
		builder.append("loginInfo=");
		builder.append(loginInfo);
		builder.append("}");
		return builder.toString();
	}
}
