package org.phosphoresce.webcore.ext.struts.action;

import java.io.Serializable;

import org.phosphoresce.webcore.ext.struts.annotation.StrutsAction;

/**
 * ダミーアクションクラス<br>
 * <br>
 * サーブレットアクションモジュールが存在しないリクエストパス受領時のリクエストプロセッサーで返却されるダミーのアクションとなります。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
@StrutsAction
public final class DummyAction extends AbstractAction<Serializable, DummyForm> {

	/**
	 * 初期表示処理を行います。<br>
	 * @param form ActionFormオブジェクト
	 * @param session セッションコンテナオブジェクト
	 * @param servlet サーブレットコンテナオブジェクト
	 * @return 遷移先パス
	 * @throws Throwable 処理中に補足されない予期せぬエラーが発生した場合にスローされます
	 * @see org.phosphoresce.webcore.ext.struts.action.AbstractAction#index(org.phosphoresce.webcore.ext.struts.action.AbstractForm, org.phosphoresce.webcore.ext.struts.action.WindowSessionContainer, org.phosphoresce.webcore.ext.struts.action.ServletContainer)
	 */
	@Override
	public Forward index(DummyForm form, WindowSessionContainer<Serializable> session, ServletContainer<Serializable> servlet) throws Throwable {
		return new Forward();
	}
}
