package org.phosphoresce.webcore.ext.struts.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.ext.struts.exception.StrutsProcessInternalException;
import org.phosphoresce.webcore.ext.struts.util.StrutsUtil;
import org.slf4j.LoggerFactory;

/**
 * リクエストプロセッサ拡張クラス<br>
 * <br>
 * Struts標準のリクエストプロセッサクラスを拡張したクラスとなります。<br>
 * 当クラスはstruts-config.xmlに未定義のアクションフォームマッピングを動的に生成する機能を提供します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public final class CustomRequestProcessor extends RequestProcessor {

	/** ロガーオブジェクト */
	private CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/**
	 * リクエストプロセッサーを初期化します。<br>
	 * @see org.apache.struts.action.RequestProcessor#init(org.apache.struts.action.ActionServlet, org.apache.struts.config.ModuleConfig)
	 */
	@Override
	public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
		super.init(servlet, moduleConfig);
		log.output("FSTR06001");
	}

	/**
	 * リクエスト処理時のActionFormに対する処理を実行します。<br>
	 * Struts標準のリクエストプロセッサをオーバーライドして動的にActionFormをロードします。<br>
	 * @see org.apache.struts.action.RequestProcessor#processActionForm(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionMapping)
	 */
	@Override
	protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
		try {
			// アクションパス取得
			String actionPath = StrutsUtil.getRequestActionPath(request, moduleConfig);

			// 指定されたリクエストパスに合致するフォームが存在しない場合はダミーのフォームを返却
			if (StrutsUtil.getFormClass(actionPath) == null) {
				return new DummyForm();
			}

			// フォーム環境オブジェクト取得
			FormBeanConfig formConfig = moduleConfig.findFormBeanConfig(mapping.getName());

			// フォーム環境オブジェクトが存在しない場合は動的に生成して追加する
			if (formConfig == null) {
				String formClass = StrutsUtil.getFormClassName(actionPath);
				// リクエストパスに対象機能が指定されていない場合はダミーフォームを返却
				if (formClass == null) {
					return new DummyForm();
				}
				formConfig = new FormBeanConfig();
				formConfig.setName(mapping.getName());
				formConfig.setType(formClass);
				moduleConfig.addFormBeanConfig(formConfig);
				log.output("FSTR06002", formConfig.getName(), formConfig.getType());
			}

			// 親クラスメソッドよりフォームオブジェクトを生成する
			return super.processActionForm(request, response, mapping);
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR06003", e);
		}
	}

	/**
	 * リクエスト処理時のActionインスタンス生成処理を実行します。<br>
	 * @see org.apache.struts.action.RequestProcessor#processActionCreate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionMapping)
	 */
	@Override
	protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
		try {
			// アクションパス取得
			String actionPath = StrutsUtil.getRequestActionPath(request, moduleConfig);

			// 指定されたリクエストパスに合致するアクションが存在しない場合はダミーのアクションを返却
			if (StrutsUtil.getActionClass(actionPath) == null) {
				return new DummyAction();
			}

			return super.processActionCreate(request, response, mapping);
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR06003", e);
		}
	}

	/**
	 * リクエスト処理例外時の処理を実行します。<br>
	 * Struts標準のリクエストプロセッサをオーバーライドしてアプリケーションサーバーにそのまま例外をスローします。<br>
	 * @see org.apache.struts.action.RequestProcessor#processException(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, java.lang.Exception, org.apache.struts.action.ActionForm, org.apache.struts.action.ActionMapping)
	 */
	protected ActionForward processException(HttpServletRequest request, HttpServletResponse response, Exception exception, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
		if (exception instanceof ServletException) {
			throw (ServletException) exception;
		} else if (exception instanceof IOException) {
			throw (IOException) exception;
		} else {
			throw new ServletException(exception);
		}
	}
}
