package org.phosphoresce.webcore.ext.struts.action;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.ModuleUtils;
import org.phosphoresce.lib.commons.util.ExceptionUtil;
import org.phosphoresce.lib.commons.util.ReflectionUtil;
import org.phosphoresce.lib.commons.util.StringUtil;
import org.phosphoresce.webcore.core.Environment;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.config.StringResource;
import org.phosphoresce.webcore.core.transaction.TransactionContainer;
import org.phosphoresce.webcore.core.transaction.TransactionManager;
import org.phosphoresce.webcore.ext.struts.annotation.OneTimeField;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsMethod;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsTransaction;
import org.phosphoresce.webcore.ext.struts.enums.CacheReflectType;
import org.phosphoresce.webcore.ext.struts.exception.StrutsFormValidationException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsInvalidTokenException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsModuleCriticalException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsModuleException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsNoLoggedinException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsProcessInternalException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsSessionTimeoutException;
import org.phosphoresce.webcore.ext.struts.util.StrutsAnnotationUtil;
import org.phosphoresce.webcore.ext.struts.util.StrutsUtil;

/**
 * アクション処理ディフォルトクラス<br>
 * <br>
 * Strutsアクション拡張クラス内のディスパッチ処理ディフォルトクラスです。<br>
 * トランザクション処理部や各種処理部を変更する場合はアクション処理クラスを別途作成してアクションクラスより呼び出します。<br>
 * 当ディフォルトアクション処理クラスでは基本的なアクションディスパッチ処理及び、例外ハンドル処理インタフェースを提供します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public class ActionProcessDefault<L extends Serializable, F extends AbstractForm<L>> extends AbstractActionProcess<L, F> {

	/**
	 * アクション処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @throws Throwable アクション処理中に例外が発生した場合にスローされます
	 * @see org.phosphoresce.webcore.ext.struts.action.AbstractActionProcess#executeProcess(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public void executeProcess(ActionContext<L, F> actionContext) throws Throwable {
		// アクションフォームキャスト
		processCastActionForm(actionContext);

		// モジュール環境オブジェクト生成
		processCreateModuleConfig(actionContext);

		// メッセージコンテナオブジェクト生成
		processCreateMessageContainer(actionContext);

		// トランザクションコンテナオブジェクト生成
		processCreateTransactionContainer(actionContext);

		// セッションコンテナタイムアウトチェック
		processCheckSessionContainerTimeout(actionContext);

		// セッションコンテナオブジェクト生成
		processCreateSessionContainer(actionContext);

		// サーブレットコンテナオブジェクト生成
		processCreateServletContainer(actionContext);

		// トランザクションマネージャ生成
		processCreateTransactionManager(actionContext);

		// ウィンドウセッションタイムアウトチェック
		processCheckWindowSessionTimeout(actionContext);

		// ウィンドウセッションオブジェクト生成
		processCreateWindowSession(actionContext);

		// クラス構成チェック
		processCheckClassStructureExist(actionContext);

		// ウィンドウセッションアクセス時刻更新
		processUpdateWindowSessionTimestamp(actionContext);

		// ログインセッションチェック
		processCheckLoginSession(actionContext);

		// トークンチェック処理
		processCheckReuqestToken(actionContext);

		// アクセスステータス更新
		processUpdateAccessStatus(actionContext);

		// アクションフォームキャッシュ反映
		processReflectFormCache(actionContext);

		// リクエストスコープフィールドクリア
		processClearOneTimeField(actionContext);

		// フォームバリデーションメソッド
		processExecuteActionFormValidation(actionContext);

		// トランザクションオープン
		processOpenTransaction(actionContext);

		// ディスパッチアクション処理
		processDispatchAction(actionContext);

		// アクションフォーム補正処理
		processCorrectActionForm(actionContext);

		// アクションフォームキャッシュ
		processCacheActionForm(actionContext);

		// トランザクションコミット
		processCommitTransaction(actionContext);

		// トークン保存処理
		processTokenSave(actionContext);

		// リクエストアトリビュート設定処理
		processReflectRequestAttribute(actionContext, null);

		// ウィンドウセッションチェックモニタ開始処理
		processStartWindowSessionMonitor(actionContext);
	}

	/**
	 * アクション終了処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @throws Throwable アクション処理処理中に例外が発生した場合にスローされます
	 * @see org.phosphoresce.webcore.ext.struts.action.AbstractActionProcess#executeFinally(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public void executeFinally(ActionContext<L, F> actionContext) throws Throwable {
		// アクションメッセージ追加
		processReflectMessage(actionContext);

		// アクションサーブレット実行時間ロギング
		processLoggingProcessedTime(actionContext);

		// メモリ使用量ロギング
		processLoggingMemoryTrace(actionContext);

		// トランザクションクローズ処理
		processCloseTransaction(actionContext);

		// ストリームクローズ処理
		processCloseStream(actionContext);
	}

	/**
	 * アドオンモジュールアプリケーション例外発生時のハンドル処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param e 例外オブジェクト
	 * @throws Throwable 例外ハンドル処理中に別の例外が発生した場合にスローされます(この場合はサーブレットエラーとして扱われます)
	 * @see org.phosphoresce.webcore.ext.struts.action.AbstractActionProcess#handleStrutsModuleApplicationException(org.phosphoresce.webcore.ext.struts.action.ActionContext, org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException)
	 */
	@Override
	public void handleStrutsModuleApplicationException(ActionContext<L, F> actionContext, StrutsModuleApplicationException e) throws Throwable {
		// リクエストアトリビュート設定処理
		processReflectRequestAttribute(actionContext, e);

		// ディスパッチ処理
		processDispatchStrutsModuleException(actionContext, e);
	}

	/**
	 * アドオンモジュール致命的例外発生時のハンドル処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param e 例外オブジェクト
	 * @throws Throwable 例外ハンドル処理中に別の例外が発生した場合にスローされます(この場合はサーブレットエラーとして扱われます)
	 * @see org.phosphoresce.webcore.ext.struts.action.AbstractActionProcess#handleStrutsCriticalModuleException(org.phosphoresce.webcore.ext.struts.action.ActionContext, org.phosphoresce.webcore.ext.struts.exception.StrutsModuleCriticalException)
	 */
	@Override
	public void handleStrutsCriticalModuleException(ActionContext<L, F> actionContext, StrutsModuleCriticalException e) throws Throwable {
		// リクエストアトリビュート設定処理
		processReflectRequestAttribute(actionContext, e);

		// ディスパッチ処理
		processDispatchStrutsModuleException(actionContext, e);
	}

	/**
	 * アドオンモジュール例外以外の例外発生時のハンドル処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param e 例外オブジェクト
	 * @throws Throwable 例外ハンドル処理中に別の例外が発生した場合にスローされます(この場合はサーブレットエラーとして扱われます)
	 * @see org.phosphoresce.webcore.ext.struts.action.AbstractActionProcess#handleThrowable(org.phosphoresce.webcore.ext.struts.action.ActionContext, java.lang.Throwable)
	 */
	@Override
	public void handleThrowable(ActionContext<L, F> actionContext, Throwable e) throws Throwable {
		// リクエストアトリビュート設定処理
		processReflectRequestAttribute(actionContext, e);

		// ディスパッチ処理
		processDispatchStrutsModuleException(actionContext, new StrutsProcessInternalException("FSTR11020", e));
	}

	/**
	 * アクションコンテキスト情報の妥当性チェックを行います。<br>
	 * 不正なアクションコンテキスト情報の場合は内部例外をスローします。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param requiredModuleConfig モジュール環境オブジェクト
	 * @param requiredServletContainer サーブレットコンテナオブジェクト
	 * @param requiredSessionContainer セッションコンテナオブジェクト
	 * @param requiredWindowSessionContainer ウィンドウセッションコンテナオブジェクト
	 * @param requiredMessageContainer メッセージコンテナオブジェクト
	 * @param requiredTransactionContainer トランザクションコンテナオブジェクト
	 * @param requiredCastedForm キャスト済みフォームオブジェクト
	 * @param requiredForward フォワードオブジェクト
	 */
	protected void validateActionContext(ActionContext<L, F> actionContext //
			, boolean requiredModuleConfig //
			, boolean requiredServletContainer //
			, boolean requiredSessionContainer //
			, boolean requiredWindowSessionContainer //
			, boolean requiredMessageContainer //
			, boolean requiredTransactionContainer //
			, boolean requiredCastedForm //
			, boolean requiredForward //
	) {
		// アクションコンテキストが存在しない場合はスキップ
		if (actionContext == null) {
			throw new StrutsProcessInternalException("FSTR11011");
		}

		// アクションコンテキスト情報取得
		Long startTime = actionContext.getStartTime();
		AbstractAction<L, F> action = actionContext.getAction();
		ActionMapping actionMapping = actionContext.getActionMapping();
		ActionForm actionForm = actionContext.getActionForm();
		ServletContext servletContext = actionContext.getServletContext();
		HttpServletRequest servletRequest = actionContext.getServletRequest();
		HttpServletResponse servletResponse = actionContext.getServletResponse();
		ModuleConfig moduleConfig = actionContext.getModuleConfig();
		ServletContainer<L> servletContainer = actionContext.getServletContainer();
		SessionContainer<L> sessionContainer = actionContext.getSessionContainer();
		WindowSessionContainer<L> windowSessionContainer = actionContext.getWindowSessionContainer();
		MessageContainer messageContainer = actionContext.getMessageContainer();
		TransactionContainer transactionContainer = actionContext.getTransactionContainer();
		F castedForm = actionContext.getCastedForm();
		Forward forward = actionContext.getForward();

		// 妥当性チェック
		if (true) {
			if (startTime == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (true) {
			if (action == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (true) {
			if (actionMapping == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (true) {
			if (actionForm == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (true) {
			if (servletContext == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (true) {
			if (servletRequest == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (true) {
			if (servletResponse == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredModuleConfig) {
			if (moduleConfig == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredServletContainer) {
			if (servletContainer == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredSessionContainer) {
			if (sessionContainer == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredWindowSessionContainer) {
			if (windowSessionContainer == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredMessageContainer) {
			if (messageContainer == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredTransactionContainer) {
			if (transactionContainer == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredCastedForm) {
			if (castedForm == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
		if (requiredForward) {
			if (forward == null) {
				throw new StrutsProcessInternalException("FSTR11011");
			}
		}
	}

	/**
	 * アクションフォームをアクションに対応するフォームオブジェクトにキャストします。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	@SuppressWarnings("unchecked")
	protected void processCastActionForm(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションコンテキスト設定
		actionContext.setCastedForm((F) actionContext.getActionForm());
	}

	/**
	 * リクエストに対応するモジュール環境オブジェクトを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCreateModuleConfig(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// モジュール環境オブジェクト生成
		ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(actionContext.getServletRequest(), actionContext.getServletContext());

		// アクションコンテキスト設定
		actionContext.setModuleConfig(moduleConfig);
	}

	/**
	 * リクエストされたパスに対応するクラス構造が正しいかチェックします。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCheckClassStructureExist(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// リクエストパス情報取得(リクエストクエリが除外されたパス)
		String actionPath = StrutsUtil.getRequestActionPath(actionContext.getServletRequest(), actionContext.getModuleConfig());

		// リクエスト機能ID取得
		String funcion = StrutsUtil.getRequestFunction(actionPath);

		// リクエスト機能IDが未指定の場合はスキップ(ディフォルト遷移する)
		if (StringUtil.isEmpty(funcion)) {
			return;
		}

		// クラス構成チェック
		StrutsUtil.checkClassStructure(actionPath);

		// クラスメソッド構成チェック
		StrutsUtil.checkClassMethodStructure(actionPath);
	}

	/**
	 * メッセージコンテナオブジェクトを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCreateMessageContainer(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// メッセージコンテナ生成
		MessageContainer messageContainer = new MessageContainer();

		// アクションコンテキスト設定
		actionContext.setMessageContainer(messageContainer);
	}

	/**
	 * トランザクションコンテナオブジェクトを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCreateTransactionContainer(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// トランザクションコンテナ生成
		TransactionContainer transactionContainer = new TransactionContainer();

		// アクションコンテキスト設定
		actionContext.setTransactionContainer(transactionContainer);
	}

	/**
	 * セッションコンテナタイムアウトチェック処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	@SuppressWarnings("unchecked")
	protected void processCheckSessionContainerTimeout(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合はチェック除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// アクションメソッドアノテーションでセッションチェック対象外の場合はチェック除外
		if (!actionMethod.checkSesion()) {
			return;
		}

		// セッションコンテナオブジェクトが保持されていない場合はエラー
		HttpSession httpSession = actionContext.getServletRequest().getSession(true);
		SessionContainer<L> sessionContainer = (SessionContainer<L>) httpSession.getAttribute(SESSION_KEY_CONTAINER);
		if (sessionContainer == null) {
			throw new StrutsSessionTimeoutException();
		}

		// セッションコンテナが破棄されている場合はエラー
		if (sessionContainer.isDisposed()) {
			throw new StrutsSessionTimeoutException();
		}
	}

	/**
	 * セッションコンテナオブジェクトを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	@SuppressWarnings({ "unchecked", "deprecation" })
	protected void processCreateSessionContainer(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// セッションコンテナオブジェクト取得
		HttpSession httpSession = actionContext.getServletRequest().getSession(true);
		SessionContainer<L> sessionContainer = ((SessionContainer<L>) httpSession.getAttribute(SESSION_KEY_CONTAINER));

		// セッションコンテナオブジェクトが存在しない場合は新規に生成
		if (sessionContainer == null) {
			sessionContainer = SessionContainer.createNewSessionContainer(httpSession);
		}

		// セッションコンテナオブジェクトが破棄されている場合は新規に生成
		if (sessionContainer.isDisposed()) {
			sessionContainer = SessionContainer.createNewSessionContainer(httpSession);
		}

		// キャストフォームにセッションIDを設定
		actionContext.getCastedForm().setControlFieldSessionId(sessionContainer.getSessionId());

		// アクションコンテキスト設定
		actionContext.setSessionContainer(sessionContainer);
	}

	/**
	 * トランザクションマネージャオブジェクトを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCreateTransactionManager(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, true // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合はチェック除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// トランザクションコンテナ取得
		TransactionContainer transactionContainer = actionContext.getTransactionContainer();
		try {
			for (StrutsTransaction strutsTransaction : actionMethod.transactions()) {
				String lookup = strutsTransaction.lookup();
				String namespace = strutsTransaction.namespace();
				Class<? extends TransactionManager> transactionManagerClass = strutsTransaction.transactionClass();
				TransactionManager transactionManager = null;
				if (StringUtil.isEmpty(namespace)) {
					transactionManager = transactionManagerClass.getConstructor(new Class[] {}).newInstance(new Object[] {});
				} else {
					transactionManager = transactionManagerClass.getConstructor(new Class[] { String.class }).newInstance(new Object[] { namespace });
				}
				transactionContainer.add(lookup, transactionManager);
			}
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR00016", e);
		}
	}

	/**
	 * サーブレットコンテナオブジェクトを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCreateServletContainer(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, true // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, true // メッセージコンテナオブジェクト必須フラグ
				, true // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// サーブレットコンテナオブジェクト生成
		ServletContainer<L> servletContainer = new ServletContainer<L>( //
				actionContext.getServletContext(), //
				actionContext.getServletRequest(), //
				actionContext.getServletResponse(), //
				actionContext.getSessionContainer(), //
				actionContext.getMessageContainer(), //
				actionContext.getTransactionContainer() //
		);

		// キャストフォームにサーブレットコンテナオブジェクトを設定
		actionContext.getCastedForm().setServlet(actionContext.getServletContainer());

		// アクションコンテキスト設定
		actionContext.setServletContainer(servletContainer);
	}

	/**
	 * ウィンドウセッションタイムアウトチェック処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCheckWindowSessionTimeout(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, true // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合はチェック除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// アクションメソッドアノテーションでセッションチェック対象外の場合はチェック除外
		if (!actionMethod.checkSesion()) {
			return;
		}

		// ウィンドウセッションコンテナ上にウィンドウセッションが存在しない場合はエラー
		if (!actionContext.getSessionContainer().containsWindowSession(actionContext.getWindowId())) {
			throw new StrutsSessionTimeoutException();
		}

		// ウィンドウセッションコンテナが破棄されている場合はエラー
		if (actionContext.getSessionContainer().getWindowSession(actionContext.getWindowId()).isDisposed()) {
			throw new StrutsSessionTimeoutException();
		}
	}

	/**
	 * ウィンドウセッションコンテナ生成処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	@SuppressWarnings("deprecation")
	protected void processCreateWindowSession(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, true // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// ウィンドウIDが未指定の場合は新規採番
		String windowId = actionContext.getWindowId();
		if (StringUtil.isEmpty(windowId)) {
			windowId = StringUtil.createRandomHash();
		}

		// ウィンドウセッションコンテナが存在しない場合は新規に生成
		WindowSessionContainer<L> windowSessionContainer = actionContext.getSessionContainer().getWindowSession(windowId);
		if (windowSessionContainer == null) {
			windowSessionContainer = WindowSessionContainer.createNewWindowSessionContainer(actionContext.getSessionContainer(), windowId);
		}

		// リクエストアトリビュートへのウィンドウID設定
		actionContext.getServletRequest().setAttribute(FIELD_KEY_WINDOW_ID, windowId);

		// キャストフォームにウィンドウIDを設定
		actionContext.getCastedForm().setControlFieldWindowId(windowId);

		// アクションコンテキスト設定
		actionContext.setWindowSessionContainer(windowSessionContainer);
	}

	/**
	 * ウィンドウセッションタイムスタンプを更新します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processUpdateWindowSessionTimestamp(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// タイムスタンプ更新
		actionContext.getWindowSessionContainer().updateLastAccessTime();
	}

	/**
	 * ログインセッションチェック処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCheckLoginSession(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合はチェック除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// アクションメソッドアノテーションでログインチェック対象外の場合はチェック除外
		if (!actionMethod.checkLogin()) {
			return;
		}

		// 未ログイン状態である場合はエラー
		if (!actionContext.getWindowSessionContainer().isLogined()) {
			throw new StrutsNoLoggedinException();
		}
	}

	/**
	 * トークンチェック処理を行います。<br>
	 * Struts標準のisTokenValidメソッドは利用せず、ウィンドウ単位のトークンチェックを実施します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCheckReuqestToken(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合はチェック除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// アクションメソッドアノテーションでトークンチェック対象外の場合はチェック除外
		if (!actionMethod.checkToken()) {
			return;
		}

		// ポップアップウィンドウリクエスト時はチェック除外
		if (StrutsUtil.isPopupRequest(actionContext.getServletRequest(), actionContext.getCastedForm())) {
			return;
		}

		// JSONリクエスト時はチェック除外
		if (StrutsUtil.isJSONReuqest(actionContext.getServletRequest(), actionContext.getCastedForm())) {
			return;
		}

		// ウィンドウセッションに保存済みトークンが存在しない場合はチェック除外
		String savedToken = actionContext.getWindowSessionContainer().getTokenId();
		if (StringUtil.isEmpty(savedToken)) {
			return;
		}

		// リクエストトークンが存在しない場合はエラー
		String requestToken = StrutsUtil.getRequestTokenId(actionContext.getServletRequest(), actionContext.getCastedForm());
		if (StringUtil.isEmpty(requestToken)) {
			throw new StrutsInvalidTokenException();
		}

		// ウィンドウセッション保存済みトークンとリクエストトークンが一致しない場合はエラー
		if (!savedToken.equals(requestToken)) {
			throw new StrutsInvalidTokenException();
		}
	}

	/**
	 * アクセスステータスを更新します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processUpdateAccessStatus(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, true // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// ログインユーザー情報が存在しない場合は処理除外
		LoginUser<L> loginUser = actionContext.getWindowSessionContainer().getLoginUser();
		if (loginUser == null) {
			return;
		}

		// ログインユーザーコードが存在しない場合は処理除外
		String userCode = loginUser.getUserCode();
		if (StringUtil.isEmpty(userCode)) {
			return;
		}

		// アクセスステータス更新
		AccessStatus accessStatus = AccessStatus.instance();
		String accessUrl = actionContext.getServletRequest().getRequestURL().toString();
		accessStatus.update(userCode, accessUrl, actionContext.getServletContainer().getProcessDate());
	}

	/**
	 * キャッシュ情報からのアクションフォームフィールド反映処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	@SuppressWarnings("unchecked")
	protected void processReflectFormCache(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合は処理除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// ウィンドウセッション上のキャッシュフォームがnullの場合は処理除外
		F cached = (F) actionContext.getWindowSessionContainer().getActionForm(actionContext.getCastedForm().getClass());
		if (cached == null) {
			return;
		}

		// キャッシュ反映
		F form = actionContext.getCastedForm();
		if (CacheReflectType.NONE.equals(actionMethod.reflectCache())) {
			log.output(StringResource.getString("FSTR11012"));
		} else if (CacheReflectType.MARKED_FIELD.equals(actionMethod.reflectCache())) {
			log.output(StringResource.getString("FSTR11013"));
			form.populateCacheField(cached);
		} else if (CacheReflectType.ALL_FIELD.equals(actionMethod.reflectCache())) {
			log.output(StringResource.getString("FSTR11014"));
			form.populateAllField(cached);
		}
	}

	/**
	 * ワンタイムフィールドのクリアを行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processClearOneTimeField(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// ワンタイムフィールドアノテーションが付与されたフィールド値をクリアする
		try {
			for (Field target : ReflectionUtil.getFields(actionContext.getCastedForm().getClass())) {
				target.setAccessible(true);
				Field field = ReflectionUtil.getField(actionContext.getCastedForm().getClass(), target.getName());
				field.setAccessible(true);
				// final属性フィールドは処理除外
				if (Modifier.isFinal(field.getModifiers())) {
					continue;
				}
				OneTimeField oneTimeField = field.getAnnotation(OneTimeField.class);
				if (oneTimeField != null) {
					field.set(actionContext.getCastedForm(), null);
					log.output("FSTR11015", target.getName());
				}
			}
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR11016", e);
		}
	}

	/**
	 * アクションフォームバリデーション処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processExecuteActionFormValidation(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合は処理除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// バリデーションメソッドが未定義の場合は処理除外
		if (StringUtil.isEmpty(actionMethod.validate())) {
			return;
		}

		// バリデーションメソッドを実行する
		try {
			String validateMethodName = actionMethod.validate();
			log.output("FSTR11003", validateMethodName);
			try {
				// バリデーションメソッド実行(boolean validateMethod(void))
				Method validateMethod = actionContext.getCastedForm().getClass().getMethod(validateMethodName);
				Boolean validateMethodReturn = (Boolean) validateMethod.invoke(actionContext.getCastedForm());
				if (!validateMethodReturn) {
					throw new StrutsFormValidationException();
				}
			} catch (NoSuchMethodException e) {
				// バリデーションメソッド実行(boolean validateMethod(SessionContainer))
				Method validateMethod = actionContext.getCastedForm().getClass().getMethod(validateMethodName, SessionContainer.class);
				Boolean validateMethodReturn = (Boolean) validateMethod.invoke(actionContext.getCastedForm(), actionContext.getServletContainer());
				if (!validateMethodReturn) {
					throw new StrutsFormValidationException();
				}
			}
		} catch (StrutsFormValidationException e) {
			// バリデーション例外はそのままスロー
			throw e;
		} catch (InvocationTargetException e) {
			// バリデーションメソッド実行時のエラーはルート要因をスロー
			if (e.getCause() != null) {
				throw new StrutsProcessInternalException("FSTR11004", e.getCause());
			} else {
				throw new StrutsProcessInternalException("FSTR11004", e);
			}
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR11005", e);
		}
	}

	/**
	 * トランザクションをオープンします。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processOpenTransaction(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, true // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// トランザクションコンテナオープン
		actionContext.getTransactionContainer().open();
	}

	/**
	 * アクションのディスパッチ処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processDispatchAction(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合は処理除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// リクエストパス情報取得(リクエストクエリが除外されたパス)
		String actionPath = StrutsUtil.getRequestActionPath(actionContext.getServletRequest(), actionContext.getModuleConfig());

		try {
			// アクションメソッド実行
			Method method = StrutsUtil.getActionMethod(actionPath);
			log.output("FSTR11006", method.getName());
			Object value = method.invoke(actionContext.getAction(), actionContext.getCastedForm(), actionContext.getWindowSessionContainer(), actionContext.getServletContainer());
			Forward forward = (Forward) (value == null || ((Forward) value).getPath() == null ? null : value);
			actionContext.setForward(forward);
			log.output("FSTR11009", forward);
		} catch (StrutsModuleCriticalException e) {
			throw e;
		} catch (InvocationTargetException e) {
			if (e.getCause() instanceof StrutsModuleCriticalException) {
				throw (StrutsModuleCriticalException) e.getCause();
			} else {
				throw new StrutsProcessInternalException("FSTR11007", e.getCause());
			}
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR11008", e);
		}
	}

	/**
	 * アドオンモジュール例外発生時のアクションのディスパッチ処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param e アプリケーション例外オブジェクト
	 */
	protected void processDispatchStrutsModuleException(ActionContext<L, F> actionContext, StrutsModuleException e) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, true // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// エラーメッセージ設定
		actionContext.getMessageContainer().addMessage(e.createApplicationMessage(actionContext));

		// フォワードオブジェクト設定
		actionContext.setForward(e.createActionForward(actionContext));

		// レスポンスステータス設定
		actionContext.setResponseStatus(e.createResponseStatus(actionContext));
	}

	/**
	 * アクションフォームの補正処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCorrectActionForm(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, true // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// アクションメソッドアノテーションが存在しない場合は処理除外
		StrutsMethod actionMethod = StrutsAnnotationUtil.getStrutsMethodAnnotation( //
				actionContext.getServletRequest(), //
				actionContext.getModuleConfig(), //
				actionContext.getAction());
		if (actionMethod == null) {
			return;
		}

		// アクションメソッドアノテーションに編集済みフラグクリア指示がある場合
		if (actionMethod.clearEdited()) {
			actionContext.getCastedForm().clearFieldEdited();
		}

		// アクションメソッドアノテーションにウィンドウスクロールクリア指示がある場合
		if (actionMethod.clearWindowScroll()) {
			actionContext.getCastedForm().clearWindowScroll();
		}
	}

	/**
	 * アクションフォームのキャッシュ処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCacheActionForm(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// ウィンドウセッションにアクションフォームをキャッシュ
		actionContext.getWindowSessionContainer().setActionForm(actionContext.getCastedForm());
	}

	/**
	 * トランザクションをコミットします。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCommitTransaction(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, true // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// トランザクションコンテナコミット
		actionContext.getTransactionContainer().commit();
	}

	/**
	 * トランザクションをロールバックします。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processRollbackTransaction(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, true // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// トランザクションコンテナロールバック
		actionContext.getTransactionContainer().rollback();
	}

	/**
	 * トランザクションをコミットします。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCloseTransaction(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, true // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// トランザクションコンテナクローズ
		if (actionContext.getTransactionContainer().isOpened()) {
			actionContext.getTransactionContainer().close();
		}
	}

	/**
	* リクエストアトリビュートの設定処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	* @param throwable 発生例外オブジェクト
	*/
	protected void processReflectRequestAttribute(ActionContext<L, F> actionContext, Throwable throwable) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// リクエストアトリビュート設定
		if (actionContext.getServletContainer() != null) {
			actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_PROCESSDATE, actionContext.getServletContainer().getProcessDate());
		}
		actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_ENVIRONMENT, Environment.getMap());
		actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_CONFIG, Config.getMap());
		actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_REQUEST, actionContext.getServletRequest());
		actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_SESSION_CONTAINER, actionContext.getServletContainer());
		actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_WINDOW_SESSION_CONTAINER, actionContext.getWindowSessionContainer());
		if (actionContext.getWindowSessionContainer() != null) {
			actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_SCREEN_DATA, actionContext.getWindowSessionContainer().getScreenData());
		}
		actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_FORM, actionContext.getCastedForm());
		if (actionContext.getServletContainer() != null) {
			actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_DOWNLOAD_ID, actionContext.getServletContainer().getDownloadId());
		}
		if (actionContext.getServletContainer() != null) {
			actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_DOWNLOAD_FILENAME, actionContext.getServletContainer().getDownloadName());
		}
		if (throwable != null) {
			actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_EXCEPTION, throwable);
			actionContext.getServletRequest().setAttribute(REQUEST_ATTR_KEY_EXCEPTION_TRACE, ExceptionUtil.getStackTraceValue(throwable));
		}
	}

	/**
	 * トークン保存処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	@SuppressWarnings("deprecation")
	protected void processTokenSave(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, true // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// フォワードオブジェクトがnullの場合はトークン保存対象外(ダウンロード処理となる為)
		if (actionContext.getForward() == null) {
			return;
		}

		// 新規トークン値生成
		String newToken = StringUtil.createRandomHash();

		// ウィンドウセッション設定
		if (actionContext.getWindowSessionContainer() != null) {
			actionContext.getWindowSessionContainer().setTokenId(newToken);
		}

		// アクションフォーム設定
		if (actionContext.getCastedForm() != null) {
			actionContext.getCastedForm().setControlFieldTokenId(newToken);
		}

		// リクエストアトリビュート設定
		if (actionContext.getServletRequest() != null) {
			actionContext.getServletRequest().setAttribute(FIELD_KEY_TOKEN_ID, newToken);
		}

		log.output("FSTR11010", newToken);
	}

	/**
	 * アクションメッセージ設定処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	@SuppressWarnings({ "unchecked" })
	protected void processReflectMessage(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, true // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		ResourceBundle bundle = ResourceBundle.getBundle("application");

		// アクションメッセージオブジェクト生成
		ActionMessages messages = new ActionMessages();
		messages.add(actionContext.getMessageContainer().getInformationActionMessages());
		messages.add(actionContext.getMessageContainer().getWarningActionMessages());
		messages.add(actionContext.getMessageContainer().getErrorActionMessages());
		messages.add(actionContext.getMessageContainer().getNoticeActionMessages());
		messages.add(actionContext.getMessageContainer().getDebugActionMessages());
		messages.add(actionContext.getMessageContainer().getTraceActionMessages());
		messages.add(actionContext.getMessageContainer().getOtherActionMessages());

		// 保存済みメッセージ取得
		ActionMessages savedMessages = actionContext.getAction().getActionMessages(actionContext.getServletRequest());

		// メッセージ追加
		for (Iterator<String> iterator1 = messages.properties(); iterator1.hasNext();) {
			String key = iterator1.next();
			for (Iterator<ActionMessage> iterator2 = messages.get(key); iterator2.hasNext();) {
				ActionMessage actionMessage = (ActionMessage) iterator2.next();
				// 重複メッセージ以外設定
				if (!StrutsUtil.containsActionMessage(savedMessages, actionMessage)) {
					String render = StringUtil.nvl(MessageFormat.format(bundle.getString(actionMessage.getKey()), actionMessage.getValues()));
					render = render.replaceAll("\n", "");
					savedMessages.add(key, actionMessage);
					log.output("FSTR11019", render);
				}
			}
		}

		// アクションメッセージ保存
		actionContext.getAction().saveActionMessages(actionContext.getServletRequest(), savedMessages);
	}

	/**
	 * ウィンドウセッションタイムアウトモニタ処理開始処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processStartWindowSessionMonitor(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, true // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// ウィンドウセッションタイムアウトモニタ開始
		actionContext.getSessionContainer().startWindowSessionMonitor();
	}

	/**
	 * ストリームオブジェクトのクローズ処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processCloseStream(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, true // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		// ウィンドウセッションタイムアウトモニタ開始
		actionContext.getServletContainer().closeStreams();
	}

	/**
	 * アクションサーブレット実行時間ロギング処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processLoggingProcessedTime(ActionContext<L, F> actionContext) {
		// 妥当性チェック
		validateActionContext(actionContext //
				, false // モジュール環境オブジェクト必須フラグ
				, false // サーブレットコンテナオブジェクト必須フラグ
				, false // セッションコンテナオブジェクト必須フラグ
				, false // ウィンドウセッションコンテナオブジェクト必須フラグ
				, false // メッセージコンテナオブジェクト必須フラグ
				, false // トランザクションコンテナオブジェクト必須フラグ
				, false // キャスト済みフォームオブジェクト必須フラグ
				, false // フォワードオブジェクト必須フラグ
		);

		double startTime = actionContext.getStartTime();
		double endTime = System.currentTimeMillis();
		double processedTime = endTime - startTime;
		log.output("FSTR11017", new DecimalFormat("0.000").format(processedTime / 1000D));
	}

	/**
	 * メモリ使用量のロギング処理を行います。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 */
	protected void processLoggingMemoryTrace(ActionContext<L, F> actionContext) {
		DecimalFormat f1 = new DecimalFormat("#,###");
		DecimalFormat f2 = new DecimalFormat("##.#");
		double freeMemory = (double) Runtime.getRuntime().freeMemory() / 1024.0;
		double maxMemory = (double) Runtime.getRuntime().maxMemory() / 1024.0;
		double totalMemory = (double) Runtime.getRuntime().totalMemory() / 1024.0;
		double usedMemory = totalMemory - freeMemory;
		double ratio = (usedMemory * 100.0 / (double) totalMemory);
		log.output("FSTR11018", f1.format(usedMemory), f2.format(ratio), f1.format(totalMemory), f1.format(maxMemory));
	}
}
