package org.phosphoresce.webcore.ext.struts.action;

import java.io.Serializable;

import org.phosphoresce.webcore.core.GlobalConstants;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.ext.struts.StrutsConstants;
import org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsModuleCriticalException;
import org.slf4j.LoggerFactory;

/**
 * アクション処理上位抽象クラス<br>
 * <br>
 * Strutsアクション拡張クラス内のディスパッチ処理を提供する上位抽象クラスです。<br>
 * アクションクラスにおけるディスパッチ以外の処理を分割することで、将来的なアクション処理の拡張を行える設計として設けられたクラスです。<b>
 * サブアクション処理クラスはすべてのこのクラスを継承して実装されます。<br>
 * 尚、一般的なアクション処理は{@link org.phosphoresce.webcore.ext.struts.action.ActionProcessDefault}としてディフォルトクラスが提供されます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractActionProcess<L extends Serializable, F extends AbstractForm<L>> implements GlobalConstants, StrutsConstants {

	/** ロガーオブジェクト */
	protected CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/**
	 * アクション処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @throws Throwable アクション処理中に例外が発生した場合にスローされます
	 */
	public abstract void executeProcess(ActionContext<L, F> actionContext) throws Throwable;

	/**
	 * アクション終了処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @throws Throwable アクション処理処理中に例外が発生した場合にスローされます
	 */
	public abstract void executeFinally(ActionContext<L, F> actionContext) throws Throwable;

	/**
	 * アドオンモジュールアプリケーション例外発生時のハンドル処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param e 例外オブジェクト
	 * @throws Throwable 例外ハンドル処理中に別の例外が発生した場合にスローされます(この場合はサーブレットエラーとして扱われます)
	 */
	public abstract void handleStrutsModuleApplicationException(ActionContext<L, F> actionContext, StrutsModuleApplicationException e) throws Throwable;

	/**
	 * アドオンモジュール致命的例外発生時のハンドル処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param e 例外オブジェクト
	 * @throws Throwable 例外ハンドル処理中に別の例外が発生した場合にスローされます(この場合はサーブレットエラーとして扱われます)
	 */
	public abstract void handleStrutsCriticalModuleException(ActionContext<L, F> actionContext, StrutsModuleCriticalException e) throws Throwable;

	/**
	 * アドオンモジュール例外以外の例外発生時のハンドル処理を実行します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @param e 例外オブジェクト
	 * @throws Throwable 例外ハンドル処理中に別の例外が発生した場合にスローされます(この場合はサーブレットエラーとして扱われます)
	 */
	public abstract void handleThrowable(ActionContext<L, F> actionContext, Throwable e) throws Throwable;
}
