package org.phosphoresce.webcore.ext.struts.action;

import java.io.Serializable;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import org.phosphoresce.webcore.core.GlobalConstants;
import org.phosphoresce.webcore.core.config.StringResource;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.core.util.RequestUtil;
import org.phosphoresce.webcore.ext.struts.StrutsConstants;
import org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsModuleCriticalException;
import org.slf4j.LoggerFactory;

/**
 * Strutsアクション上位抽象クラス<br>
 * <br>
 * 各サブアクションクラスは必ずこれを継承して実装します。<br>
 * サブクラスでは1つのアクションクラス上に(T extends AbstractForm, SessionContainer, ServletContainer)を持つアクション処理メソッドを複数作成します。<br>
 * 当クラスによってリクエストパスの後ろ側に指定されたパスを基にそれらのメソッドを実行する処理が提供されます。<br>
 * <pre>
 * リクエストパス      ：～/Function/login
 * 実行されるアクション：FunctionAction
 * 実行されるメソッド  ：login(T extends AbstractForm, WindowSessionContainer, ServletContainer)
 * </pre>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/03	Kitagawa		全体的に再構築
 * 2012/09/20	Kitagawa		バリデーションメソッドはセッションコンテナオブジェクトをパラメータと持つメソッドも許可するように修正
 * 2012/10/02	Kitagawa		フィールドキャッシュ反映について、独自ReflectionUtilを利用した親クラス定義フィールドを検索するように修正
 * 2012/10/03	Kitagawa		フィールドキャッシュ反映時にfinal、transientは無視するように修正
 * 2012/11/08	Kitagawa		編集済みフラグ制御追加によりindex時には無条件にクリアする処理を追加
 * 2012/11/28	Kitagawa		セッションタイムアウト時の挙動をJSONリクエスト時と通常で分岐するように修正(JSONリクエスト時にページ遷移するとクライアント側でパースエラーとなる為)
 * 2012/11/28	Kitagawa		JSONリクエスト、ポップアップリクエスト時のセッションタイムアウトメッセージを変更
 * 2012/11/28	Kitagawa		セッションタイムアウト時はレスポンスステータスにInternalServerErrorを設定してクライアント側でレスポンスコードから判断できるように修正
 * 2012/11/28	Kitagawa		テスト時の動作として常に強制的なロールバック動作を行う挙動を環境設定ファイルから指定できるように機能追加
 * 2012/12/01	Kitagawa		ウィンドウID生成についてミリ秒ではなくミリ秒＋ランダム文字列＋イテレートされる文字群から生成するように修正(同時実行時の信頼性向上)
 * 2012/12/08	Kitagawa		トランザクションレスポンス向上のためステートメントキャッシュ機構を持たせるとともにAction終了時に全てのステートメントをクローズするように修正
 * 2013/04/18	Kitagawa		メンテナンス機能処理時等でエラー監視除外とする為、エラーログを出力させないフックメソッドを追加
 * 2013/04/26	Kitagawa		システムエラー時にリクエスト情報と実行データベースクエリをトレースするように処理追加
 * 2013/05/01	Kitagawa		アクション呼び出しのタイミングでユーザー毎の最終アクセス情報を管理するように処理追加
 * 2013/05/17	Kitagawa		テンポラリリソース経由のダウンロードリダイレクト処理を追加
 * 2013/05/28	Kitagawa		先頭へのメッセージ追加インタフェースを追加
 * 2013/05/29	Kitagawa		処理中にブラウザを強制終了した場合等、レスポンスが完了されなかった場合に致命的例外扱いとしないように修正
 *-->
 */
public abstract class AbstractAction<L extends Serializable, F extends AbstractForm<L>> extends Action implements GlobalConstants, StrutsConstants {

	/** ロガーオブジェクト */
	private CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/**
	 * リクエストアクション処理を実行します。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	@Deprecated
	public final ActionForward execute(final ActionMapping actionMapping, final ActionForm actionform, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		try {
			/*
			 * リクエスト情報デバッグ
			 */
			RequestUtil.debugRequest(request);

			/*
			 * アクションコンテキスト生成
			 */
			ActionContext<L, F> actionContext = new ActionContext<L, F>();
			actionContext.setAction(this);
			actionContext.setActionMapping(actionMapping);
			actionContext.setActionForm(actionform);
			actionContext.setServletRequest(request);
			actionContext.setServletResponse(response);
			//actionContext.setServletContext(super.getServlet().getServletContext()); // Strutsパスが不正な場合にnullとなる
			//actionContext.setServletContext(request.getServletContext()); // Servlet3.0以降でのインタフェース
			actionContext.setServletContext(request.getSession(true).getServletContext());
			actionContext.setStartTime(System.currentTimeMillis());

			/*
			 * アクションプロセッサー処理
			 */
			AbstractActionProcess<L, F> actionProcess = new ActionProcessDefault<L, F>();
			try {
				// アクションプロセス処理
				actionProcess.executeProcess(actionContext);
			} catch (StrutsModuleApplicationException e) {
				// アドオンモジュールアプリケーション例外ハンドル処理
				//log.output(e, "FSTR09002");
				actionProcess.handleStrutsModuleApplicationException(actionContext, e);
			} catch (StrutsModuleCriticalException e) {
				// アドオンモジュール致命的例外ハンドル処理
				log.output(e, "FSTR09002");
				actionProcess.handleStrutsCriticalModuleException(actionContext, e);
			} catch (Throwable e) {
				// アドオンモジュール以外の例外ハンドル処理
				log.output(e, "FSTR09002");
				actionProcess.handleThrowable(actionContext, e);
			} finally {
				// アクションプロセス終了処理
				actionProcess.executeFinally(actionContext);
			}

			// アクションフォーワード生成処理
			ActionForward actionForward = null;
			if (actionContext.getForward() != null) {
				actionForward = actionContext.getForward().createActionForward(actionContext);
			}

			return actionForward;
		} catch (Throwable e) {
			throw new ServletException(StringResource.getString("FSTR00017"), e);
		}
	}

	/**
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * 上位から呼び出されたタイミングでexecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)が呼び出されます。<br>
	 * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.ServletRequest, javax.servlet.ServletResponse)
	 */
	@Override
	@Deprecated
	public final ActionForward execute(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws Exception {
		return super.execute(mapping, form, request, response);
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#generateToken(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	@Deprecated
	protected final String generateToken(HttpServletRequest request) {
		//return super.generateToken(request);
		throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#resetToken(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	@Deprecated
	protected final void resetToken(HttpServletRequest request) {
		//super.resetToken(request);
		throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#saveToken(javax.servlet.http.HttpServletRequest)
	 */
	@Deprecated
	@Override
	protected final void saveToken(HttpServletRequest request) {
		//super.saveToken(request);
		throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#getServlet()
	 */
	@Deprecated
	@Override
	public final ActionServlet getServlet() {
		return super.getServlet();
		//throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#setServlet(org.apache.struts.action.ActionServlet)
	 */
	@Deprecated
	@Override
	public final void setServlet(ActionServlet servlet) {
		super.setServlet(servlet);
		//throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#isCancelled(javax.servlet.http.HttpServletRequest)
	 */
	@Deprecated
	@Override
	protected final boolean isCancelled(HttpServletRequest request) {
		//return super.isCancelled(request);
		throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#isTokenValid(javax.servlet.http.HttpServletRequest)
	 */
	@Deprecated
	@Override
	protected final boolean isTokenValid(HttpServletRequest request) {
		//return super.isTokenValid(request);
		throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#isTokenValid(javax.servlet.http.HttpServletRequest, boolean)
	 */
	@Deprecated
	@Override
	protected final boolean isTokenValid(HttpServletRequest request, boolean reset) {
		//return super.isTokenValid(request, reset);
		throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#getLocale(javax.servlet.http.HttpServletRequest)
	 */
	@Deprecated
	@Override
	protected Locale getLocale(HttpServletRequest request) {
		//return super.getLocale(request);
		throw new NoSuchMethodError();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.Action#setLocale(javax.servlet.http.HttpServletRequest, java.util.Locale)
	 */
	@Deprecated
	@Override
	protected void setLocale(HttpServletRequest request, Locale locale) {
		//super.setLocale(request, locale);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ追加メソッドは利用しません。<br>
	 * 当クラスが提供するaddInformation、addErrorを利用して下さい。<br>
	 * @see org.apache.struts.action.Action#addMessages(javax.servlet.http.HttpServletRequest, org.apache.struts.action.ActionMessages)
	 */
	@Override
	@Deprecated
	protected final void addMessages(HttpServletRequest request, ActionMessages messages) {
		//super.addMessages(request, messages);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ追加メソッドは利用しない。<br>
	 * 当クラスが提供するaddInformation、addErrorを利用して下さい。<br>
	 * @see org.apache.struts.action.Action#addErrors(javax.servlet.http.HttpServletRequest, org.apache.struts.action.ActionMessages)
	 */
	@Override
	@Deprecated
	protected final void addErrors(HttpServletRequest request, ActionMessages errors) {
		//super.addErrors(request, errors);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ保存メソッドは利用しません。<br>
	 * @see org.apache.struts.action.Action#saveErrors(javax.servlet.http.HttpServletRequest, org.apache.struts.action.ActionMessages)
	 */
	@Override
	@Deprecated
	protected final void saveErrors(HttpServletRequest request, ActionMessages errors) {
		//super.saveErrors(request, errors);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ保存メソッドは利用しません。<br>
	 * @see org.apache.struts.action.Action#saveMessages(javax.servlet.http.HttpServletRequest, org.apache.struts.action.ActionMessages)
	 */
	@Override
	@Deprecated
	protected final void saveMessages(HttpServletRequest request, ActionMessages messages) {
		//super.saveMessages(request, messages);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ保存メソッドは利用しません。<br>
	 * @see org.apache.struts.action.Action#saveMessages(javax.servlet.http.HttpSession, org.apache.struts.action.ActionMessages)
	 */
	@Override
	@Deprecated
	protected final void saveMessages(HttpSession session, ActionMessages messages) {
		//super.saveMessages(session, messages);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ保存メソッドは利用しません。<br>
	 * @see org.apache.struts.action.Action#saveErrors(javax.servlet.http.HttpSession, org.apache.struts.action.ActionMessages)
	 */
	@Override
	@Deprecated
	protected final void saveErrors(HttpSession session, ActionMessages errors) {
		//super.saveErrors(session, errors);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ取得メソッドは利用しません。<br>
	 * MessageContainerクラスが提供するインタフェースを利用します。<br>
	 * @see org.apache.struts.action.Action#getErrors(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	@Deprecated
	protected final ActionMessages getErrors(HttpServletRequest request) {
		//return super.getErrors(request);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージ取得メソッドは利用しません。<br>
	 * MessageContainerクラスが提供するインタフェースを利用します。<br>
	 * @see org.apache.struts.action.Action#getMessages(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	@Deprecated
	protected final ActionMessages getMessages(HttpServletRequest request) {
		//return super.getMessages(request);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージリソース取得メソッドは利用しません。<br>
	 * StringResourcesが提供するインタフェースを利用したメッセージ操作を行います。<br>
	 * @see org.apache.struts.action.Action#getResources(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	@Deprecated
	protected final MessageResources getResources(HttpServletRequest request) {
		//return super.getResources(request);
		throw new NoSuchMethodError();
	}

	/**
	 * Struts標準のメッセージリソース取得メソッドは利用しません。<br>
	 * StringResourcesが提供するインタフェースを利用したメッセージ操作を行います。<br>
	 * @see org.apache.struts.action.Action#getResources(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	@Override
	@Deprecated
	protected final MessageResources getResources(HttpServletRequest request, String key) {
		//return super.getResources(request, key);
		throw new NoSuchMethodError();
	}

	/**
	 * アクションメッセージオブジェクトを取得します。<br>
	 * @param request リクエストオブジェクト
	 * @return アクションメッセージオブジェクト
	 */
	final ActionMessages getActionMessages(HttpServletRequest request) {
		return super.getErrors(request);
	}

	/**
	 * アクションメッセージオブジェクトを保存します。<br>
	 * @param request リクエストオブジェクト
	 * @param messages アクションメッセージオブジェクト
	 */
	final void saveActionMessages(HttpServletRequest request, ActionMessages messages) {
		super.getErrors(request);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(ServletContainer<L> servlet, String code, Object... binds) {
		servlet.getMessage().addMessage(code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(ServletContainer<L> servlet, String code) {
		servlet.getMessage().addMessage(code);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(ServletContainer<L> servlet, Integer row, String code, Object... binds) {
		servlet.getMessage().addMessage(row, code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(ServletContainer<L> servlet, Integer row, String code) {
		servlet.getMessage().addMessage(row, code);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(ServletContainer<L> servlet, String code, Object... binds) {
		servlet.getMessage().addMessageOnHead(code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(ServletContainer<L> servlet, String code) {
		servlet.getMessage().addMessageOnHead(code);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(ServletContainer<L> servlet, Integer row, String code, Object... binds) {
		servlet.getMessage().addMessageOnHead(row, code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(ServletContainer<L> servlet, Integer row, String code) {
		servlet.getMessage().addMessageOnHead(row, code);
	}

	/**
	 * 初期表示処理を行います。<br>
	 * @param form ActionFormオブジェクト
	 * @param session セッションコンテナオブジェクト
	 * @param servlet サーブレットコンテナオブジェクト
	 * @return 遷移先パス
	 * @throws Throwable 処理中に補足されない予期せぬエラーが発生した場合にスローされます
	 */
	public abstract Forward index(F form, WindowSessionContainer<L> session, ServletContainer<L> servlet) throws Throwable;
}
