package org.phosphoresce.webcore.ext.smartlayout.taglib.util;

import org.phosphoresce.lib.commons.util.StringUtil;

/**
 * フレームワークコーディング準拠タグツールクラス(エスケープ処理)<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
public class SmartTagUtil {

	/** ユニークキーカウンタ */
	private static long uniqueKeyCoutner;

	/**
	 * コンストラクタ<br>
	 */
	public SmartTagUtil() {
		super();
	}

	/**
	 * 指定された文字列をそのまま提供します。<br>
	 * @param value 対象文字列
	 * @return 文字列
	 */
	public static String c(String value) {
		return value;
	}

	/**
	 * 指定された文字列をHTMLエスケープして提供します。<br>
	 * @param value 対象文字列
	 * @return HTMLエスケープ
	 */
	public static String escape(String value) {
		return StringUtil.nvl(StringUtil.toHTMLAttribute(value));
	}

	/**
	 * ユニーク文字列を取得します。<br>
	 * @return ユニーク文字列
	 */
	public static String uniqueKey() {
		return StringUtil.toMD5Hash(String.valueOf(uniqueKeyCoutner++));
	}
}
