package org.phosphoresce.webcore.ext.smartlayout.taglib;

import org.phosphoresce.webcore.ext.smartlayout.model.TabPageModel;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.LooseTagConfig;

/**
 * タブパネルコンテナタグクラス<br>
 * <br>
 * 実際のカスタムタグ処理は上位{@link org.phosphoresce.webcore.ext.smartlayout.taglib.LooseTagAdapter}が提供し、
 * 当クラスでの処理提供は行いませんが、{@link javax.servlet.jsp.tagext.Tag}インタフェースを実装した
 * 各タグごとのクラス設置が必要である為、設けられたクラスです。<br>
 * {@link org.phosphoresce.webcore.ext.smartlayout.taglib.LooseTagAdapter}を継承する各種タグクラスは必ず
 * {@link org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.LooseTagAdapterConfig}アノテーションを
 * 付与する必要があり、ここで定義されたモデルクラスでタグが管理する属性、テンプレート情報を提供します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/05	Kitagawa		新規作成
 *-->
 */
@LooseTagConfig(modelClass = TabPageModel.class)
public class TabPage extends LooseTagAdapter {

	/**
	 * コンストラクタ<br>
	 */
	public TabPage() {
		super();
	}
}
