package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.exception.SmartLayoutTaglibProcessException;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * テーブルリストタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "TableListS.vm", endTemplate = "TableListE.vm")
public class TableListModel extends AbstractModel {

	/** エレメントデータ */
	@SmartTagAttributeField
	private String data;

	/** 幅 */
	@SmartTagAttributeField
	private String width;

	/** 高さ */
	@SmartTagAttributeField
	private String height;

	/**
	 * コンストラクタ<br>
	 */
	public TableListModel() {
		super();
	}

	/**
	 * モデル階層妥当性をチェックします。<br>
	 * @throws Throwable 不正な階層構造の場合にスローされます
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#checkModelHierarchy()
	 */
	@Override
	protected void checkModelHierarchy() throws Throwable {
		/*
		 * 子タグがTableListColumnクラスでない場合はエラー
		 */
		for (SmartTagModel child : getChilds()) {
			if (!(child instanceof TableListColumnModel)) {
				throw new SmartLayoutTaglibProcessException("FSML00014", new Object[] { //
						getClass().getSimpleName(), //
								TableListColumnModel.class.getSimpleName(), //
								child == null ? "null" : child.getClass().getSimpleName() //
						});
			}
		}
	}

	/**
	 * 子モデルオブジェクト追加時のハンドラ処理を行います。<br>
	 * @param model 子モデルオブジェクト
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#handleAddChild(org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel)
	 */
	@Override
	protected void handleAddChild(SmartTagModel model) {
		model.setManualOutput(true);
	}

	/**
	 * エレメントデータを取得します。<br>
	 * @return エレメントデータ
	 */
	public String getData() {
		return data;
	}

	/**
	 * エレメントデータを設定します。<br>
	 * @param data エレメントデータ
	 */
	public void setData(String data) {
		this.data = data;
	}

	/**
	 * 幅を取得します。<br>
	 * @return 幅
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * 幅を設定します。<br>
	 * @param width 幅
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * 高さを取得します。<br>
	 * @return 高さ
	 */
	public String getHeight() {
		return height;
	}

	/**
	 * 高さを設定します。<br>
	 * @param height 高さ
	 */
	public void setHeight(String height) {
		this.height = height;
	}
}
