package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.lib.commons.util.StringUtil;
import org.phosphoresce.webcore.ext.smartlayout.exception.SmartLayoutTaglibProcessException;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * テーブルリストカラムタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "TableListColumnS.vm", endTemplate = "TableListColumnE.vm")
public class TableListColumnModel extends SmartTagModel {

	/** ラベル */
	@SmartTagAttributeField
	private String label;

	/** 幅 */
	@SmartTagAttributeField
	private String width;

	/**
	 * コンストラクタ<br>
	 */
	public TableListColumnModel() {
		super();
	}

	/**
	 * モデル階層妥当性をチェックします。<br>
	 * @throws Throwable 不正な階層構造の場合にスローされます
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#checkModelHierarchy()
	 */
	@Override
	protected void checkModelHierarchy() throws Throwable {
		/*
		 * 親タグがTableListModelでない場合はエラー
		 */
		if (!(getParent() instanceof TableListModel)) {
			throw new SmartLayoutTaglibProcessException("FSML00013", new Object[] { //
					getClass().getSimpleName(), //
							TableListModel.class.getSimpleName(), //
							getParent() == null ? "null" : getParent().getClass().getSimpleName(), //
					});
		}
		/*
		 * 2つ以上の子タグを持つ場合はエラー
		 */
		if (getChilds().size() >= 2) {
			throw new SmartLayoutTaglibProcessException("FSML00016", new Object[] { //
					getClass().getSimpleName(), //
					});
		}
	}

	/**
	 * 子モデルオブジェクト追加時のハンドラ処理を行います。<br>
	 * @param model 子モデルオブジェクト
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#handleAddChild(org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel)
	 */
	@Override
	protected void handleAddChild(SmartTagModel model) {
		model.setManualOutput(true);
	}

	/**
	 * ラベルを取得します。<br>
	 * @return ラベル
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * ラベルを設定します。<br>
	 * @param label ラベル
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * 幅を取得します。<br>
	 * @return 幅
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * 幅を設定します。<br>
	 * @param width 幅
	 */
	public void setWidth(String width) {
		this.width = width;
	}
}
