package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * テキスト系要素上位モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractTextModel extends AbstractNamedModel {

	/** 最大文字数 */
	@SmartTagAttributeField
	private String maxlength;

	/** 幅 */
	@SmartTagAttributeField
	private String width;

	/** 高さ */
	@SmartTagAttributeField
	private String height;

	/**
	 * コンストラクタ<br>
	 */
	public AbstractTextModel() {
		super();
	}

	/**
	 * 最大文字数を取得します。<br>
	 * @return 最大文字数
	 */
	public final String getMaxlength() {
		return maxlength;
	}

	/**
	 * 最大文字数を設定します。<br>
	 * @param maxlength 最大文字数
	 */
	public final void setMaxlength(String maxlength) {
		this.maxlength = maxlength;
	}

	/**
	 * 幅を取得します。<br>
	 * @return 幅
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * 幅を設定します。<br>
	 * @param width 幅
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * 高さを取得します。<br>
	 * @return 高さ
	 */
	public String getHeight() {
		return height;
	}

	/**
	 * 高さを設定します。<br>
	 * @param height 高さ
	 */
	public void setHeight(String height) {
		this.height = height;
	}
}
