package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * プロパティ属性保持上位モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractNamedModel extends AbstractModel {

	/** エレメントプロパティ */
	@SmartTagAttributeField
	private String name;

	/**
	 * コンストラクタ<br>
	 */
	public AbstractNamedModel() {
		super();
	}

	/**
	 * エレメントプロパティを取得します。<br>
	 * @return エレメントプロパティ
	 */
	public final String getName() {
		return name;
	}

	/**
	 * エレメントプロパティを設定します。<br>
	 * @param name エレメントプロパティ
	 */
	public final void setName(String name) {
		this.name = name;
	}
}
