package org.phosphoresce.webcore.ext.jdbc.factory;

import java.sql.Connection;
import java.sql.DriverManager;

import org.phosphoresce.webcore.ext.jdbc.JDBCConstants;

/**
 * JDBC利用データベースコネクションファクトリ<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2011/12/24	Kitagawa		新規作成
 *-->
 */
public class JDBCDriverConnectionFactory extends JDBCConnectionFactory implements JDBCConstants {

	/** JDBCドライバ */
	private String jdbcDriver;

	/** JDBC接続URL */
	private String jdbcUrl;

	/** JDBCユーザ */
	private String jdbcUser;

	/** JDBCパスワード */
	private String jdbcPassword;

	/**
	 * コンストラクタ<br>
	 * @param jdbcDriver JDBCドライバ
	 * @param jdbcUrl JDBC接続URL
	 * @param jdbcUser JDBCユーザ
	 * @param jdbcPassword JDBCパスワード
	 * @param autoCommit 自動コミットフラグ
	 */
	public JDBCDriverConnectionFactory(String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPassword, boolean autoCommit) {
		super(autoCommit);
		this.jdbcDriver = jdbcDriver;
		this.jdbcUrl = jdbcUrl;
		this.jdbcUser = jdbcUser;
		this.jdbcPassword = jdbcPassword;
	}

	/**
	 * データベースコネクションを生成します。<br>
	 * @return データベースコネクションオブジェクト
	 * @throws Throwable 正常にデータベースコネクションが確立できなかった場合にスローされます
	 * @see org.phosphoresce.webcore.ext.jdbc.factory.JDBCConnectionFactory#createConnection()
	 */
	@Override
	public Connection createConnection() throws Throwable {
		Class.forName(jdbcDriver);
		Connection connection = DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPassword);
		connection.setAutoCommit(isAutoCommit());
		return connection;
	}
}
