package org.phosphoresce.webcore.ext.jdbc.exception;

import org.phosphoresce.webcore.core.exception.WebcoreCriticalException;

/**
 * データベース接続アドオントランザクション例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/07	Kitagawa		新規作成
 *-->
 */
public class JDBCTransactionException extends WebcoreCriticalException {

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param cause 例外要因
	 */
	public JDBCTransactionException(String code, Throwable cause) {
		super(code, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param binds 例外メッセージバインドオブジェクト
	 * @param cause 例外要因
	 */
	public JDBCTransactionException(String code, Object[] binds, Throwable cause) {
		super(code, binds, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 */
	public JDBCTransactionException(String code) {
		super(code);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 * @param binds 例外メッセージバインドオブジェクト
	 */
	public JDBCTransactionException(String code, Object[] binds) {
		super(code, binds);
	}
}
