package org.phosphoresce.webcore.ext.jdbc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * データベース接続アドオン環境変数保持クラス<br>
 * <br>
 * 当クラスはアプリケーション起動時に初期化され、アプリケーション実行中は永続的に情報を保持し続けます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/06	Kitagawa		新規作成
 *-->
 */
public class JDBCEnvironment implements Serializable, JDBCConstants {

	/** データベース接続可能フラグ */
	private static boolean enabledDatabase;

	/**
	 * 環境変数内容をMapオブジェクトとして取得します。<br>
	 * @return Mapオブジェクト
	 */
	public static Map<String, Object> getMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("enabledDatabase", enabledDatabase);
		return map;
	}

	/**
	 * コンストラクタ<br>
	 */
	private JDBCEnvironment() {
		super();
	}

	/**
	 * データベース接続可能フラグを取得します。<br>
	 * @return データベース接続可能フラグ
	 */
	public static boolean isEnabledDatabase() {
		return enabledDatabase;
	}

	/**
	 * データベース接続可能フラグを設定します。<br>
	 * @param enabledDatabase データベース接続可能フラグ
	 */
	public static void setEnabledDatabase(boolean enabledDatabase) {
		JDBCEnvironment.enabledDatabase = enabledDatabase;
	}
}
