package org.phosphoresce.webcore.ext.jdbc;

import org.phosphoresce.webcore.core.ConfigName;

/**
 * データベース接続アドオン環境設定定義名列挙クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public class JDBCConfigName extends ConfigName {

	/** JDBC接続タイプ定義 */
	public static final JDBCConfigName JDBC_CONNECTION_TYPE = new JDBCConfigName("jdbc.connection.type");

	/** JDBC接続名前空間定義 */
	public static final JDBCConfigName JDBC_CONNECTION_NAMESPACES = new JDBCConfigName("jdbc.connection.namespaces");

	/** JDBCドライバクラス定義 */
	public static final JDBCConfigName JDBC_DRIVER = new JDBCConfigName("jdbc.driver");

	/** JDBC接続URL定義 */
	public static final JDBCConfigName JDBC_URL = new JDBCConfigName("jdbc.url");

	/** JDBC接続ユーザー定義 */
	public static final JDBCConfigName JDBC_USER = new JDBCConfigName("jdbc.user");

	/** JDBC接続パスワード定義 */
	public static final JDBCConfigName JDBC_PASSWORD = new JDBCConfigName("jdbc.password");

	/** JDBC自動コミット定義 */
	public static final JDBCConfigName JDBC_AUTOCOMMIT = new JDBCConfigName("jdbc.autocommit");

	/** JDBCデータソース名定義 */
	public static final JDBCConfigName JDCB_DATASOURCE_NAME = new JDBCConfigName("jdbc.datasource.name");

	/**
	 * コンストラクタ<br>
	 * @param key プロパティキー
	 */
	protected JDBCConfigName(String key) {
		super(key);
	}
}
