package org.phosphoresce.webcore.ext.dynapage.model.element;

import org.phosphoresce.webcore.ext.dynapage.model.AbstractModel;
import org.phosphoresce.webcore.ext.dynapage.model.FieldModel;

/**
 * リストオプションエレメント定義モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
@FieldModel(template = "/org/phosphoresce/webcore/ext/dynapage/template/element/OptionElement.vm")
public class OptionElement extends AbstractModel {

	/** ラベル */
	private String label = null;

	/** エレメント値 */
	private String value;

	/**
	 * コンストラクタ<br>
	 */
	public OptionElement() {
		super();
	}

	/**
	 * ラベルを取得します。<br>
	 * @return ラベル
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * ラベルを設定します。<br>
	 * @param label ラベル
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * エレメント値を取得します。<br>
	 * @return エレメント値
	 */
	public final String getValue() {
		return value;
	}

	/**
	 * エレメント値を設定します。<br>
	 * @param value エレメント値
	 */
	public final void setValue(String value) {
		this.value = value;
	}
}
