package org.phosphoresce.webcore.ext.dynapage.model.element;

import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.webcore.ext.dynapage.model.AbstractModel;

/**
 * リストエレメント定義モデル上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractListElement extends AbstractModel {

	/** エレメント名 */
	private String name;

	/** リストオプション */
	private List<OptionElement> options = new LinkedList<OptionElement>();

	/** 編集不可フラグ */
	private boolean disabled;

	/**
	 * コンストラクタ<br>
	 */
	public AbstractListElement() {
		super();
	}

	/**
	 * エレメント名を取得します。<br>
	 * @return エレメント名
	 */
	public final String getName() {
		return name;
	}

	/**
	 * エレメント名を設定します。<br>
	 * @param name エレメント名
	 */
	public final void setName(String name) {
		this.name = name;
	}

	/**
	 * リストオプションを追加します。<br>
	 * @param option リストオプション
	 */
	public final void addOption(OptionElement option) {
		options.add(option);
	}

	/**
	 * リストオプションを削除します。<br>
	 * @param option リストオプション
	 */
	public final void removeOption(OptionElement option) {
		options.remove(option);
	}

	/**
	 * リストオプションをクリアします。<br>
	 */
	public final void clearOption() {
		options.clear();
	}

	/**
	 * リストオプションを取得します。<br>
	 * @return リストオプション
	 * @deprecated テンプレートエンジンからの利用の為に設けられたメソッドであり、Javaからの直接利用は推奨されません
	 */
	@Deprecated
	public final List<OptionElement> getOptions() {
		return options;
	}

	/**
	 * リストオプションを設定します。<br>
	 * @param options リストオプション
	 */
	private final void setOptions(List<OptionElement> options) {
		this.options = options;
	}

	/**
	 * 編集不可フラグを取得します。<br>
	 * @return 編集不可フラグ
	 */
	public final boolean isDisabled() {
		return disabled;
	}

	/**
	 * 編集不可フラグを設定します。<br>
	 * @param disabled 編集不可フラグ
	 */
	public final void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}
}
