package org.phosphoresce.webcore.core.util;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.slf4j.LoggerFactory;

/**
 * サーブレットユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/06/23	Kitagawa		新規作成
 *-->
 */
public class RequestUtil {

	/** ロガーオブジェクト */
	private static CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(RequestUtil.class));

	/**
	 * コンストラクタ<br>
	 */
	private RequestUtil() {
		super();
	}

	/**
	 * サーブレットリクエストオブジェクトをデバッグします。<br>
	 */
	public static void debugRequest(HttpServletRequest request) {
		if (request == null) {
			return;
		}

		StringBuilder builder = new StringBuilder();

		/*
		 * 基本ヘッダ情報
		 */
		builder.append("Protocol           : ").append(request.getProtocol()).append("\n");
		builder.append("Scheme             : ").append(request.getScheme()).append("\n");
		builder.append("Method             : ").append(request.getMethod()).append("\n");
		builder.append("CharacterEncoding  : ").append(request.getCharacterEncoding()).append("\n");
		builder.append("AuthType           : ").append(request.getAuthType()).append("\n");
		builder.append("ContentType        : ").append(request.getContentType()).append("\n");
		builder.append("ContentLength      : ").append(request.getContentLength()).append("\n");
		builder.append("ContextPath        : ").append(request.getContextPath()).append("\n");
		builder.append("PathInfo           : ").append(request.getPathInfo()).append("\n");
		builder.append("PathTranslated     : ").append(request.getPathTranslated()).append("\n");
		builder.append("QueryString        : ").append(request.getQueryString()).append("\n");
		builder.append("RequestedSessionId : ").append(request.getRequestedSessionId()).append("\n");
		builder.append("ServerName         : ").append(request.getServerName()).append("\n");
		builder.append("ServletPath        : ").append(request.getServletPath()).append("\n");
		builder.append("LocalAddr          : ").append(request.getLocalAddr()).append("\n");
		builder.append("LocalName          : ").append(request.getLocalName()).append("\n");
		builder.append("LocalPort          : ").append(request.getLocalPort()).append("\n");
		builder.append("RemoteAddr         : ").append(request.getRemoteAddr()).append("\n");
		builder.append("RemoteHost         : ").append(request.getRemoteHost()).append("\n");
		builder.append("RemotePort         : ").append(request.getRemotePort()).append("\n");
		builder.append("RemoteUser         : ").append(request.getRemoteUser()).append("\n");
		builder.append("RequestURI         : ").append(request.getRequestURI()).append("\n");
		builder.append("RequestURL         : ").append(request.getRequestURL()).append("\n");

		/*
		 * リクエスト属性情報
		 */
		Map<String, Object> attributes = new LinkedHashMap<String, Object>();
		if (request.getAttributeNames() != null) {
			for (@SuppressWarnings("unchecked")
			Enumeration<String> e = request.getAttributeNames(); e.hasMoreElements();) {
				String name = e.nextElement();
				attributes.put(name, request.getAttribute(name));
			}
		}
		builder.append("Attributes         : ").append(attributes.toString()).append("\n");

		/*
		 * リクエストヘッダ情報
		 */
		Map<String, Object> headers = new LinkedHashMap<String, Object>();
		if (request.getHeaderNames() != null) {
			for (@SuppressWarnings("unchecked")
			Enumeration<String> e = request.getHeaderNames(); e.hasMoreElements();) {
				String name = e.nextElement();
				headers.put(name, request.getHeader(name));
			}
		}
		builder.append("Headers            : ").append(headers.toString()).append("\n");

		/*
		 * リクエストパラメータ情報
		 */
		Map<String, Object> parameters = new LinkedHashMap<String, Object>();
		if (request.getParameterNames() != null) {
			for (@SuppressWarnings("unchecked")
			Enumeration<String> e = request.getParameterNames(); e.hasMoreElements();) {
				String name = e.nextElement();
				if (request.getParameterValues(name) != null && request.getParameterValues(name).length > 1) {
					StringBuilder b = new StringBuilder();
					b.append("{");
					for (String v : request.getParameterValues(name)) {
						b.append(v);
						b.append(", ");
					}
					parameters.put(name, b.substring(0, b.length() - 2) + "}");
				} else {
					parameters.put(name, request.getParameter(name));
				}
			}
		}
		builder.append("Parameters         : ").append(parameters.toString()).append("\n");

		/*
		 * クッキー情報
		 */
		Map<String, Object> cookies = new LinkedHashMap<String, Object>();
		if (request.getCookies() != null) {
			for (Cookie cookie : request.getCookies()) {
				cookies.put(cookie.getName(), cookie.getValue());
			}
		}
		builder.append("Cookies            : ").append(cookies.toString()).append("\n");

		String string = builder.toString();
		string = string.substring(0, string.length() - "\n".length());

		log.output("FCRE00015", request.getClass().getSimpleName(), string);
	}
}
