/**
 * アプリケーションにおけるトランザクション処理関連クラス構造を標準化するために各種クラスを提供します。
 * <p>
 * アドオントランザクションモジュールはこのクラス構成に準拠した構成でクラス設計され、
 * その他のアドオンモジュールから共通的なインタフェースでトランザクション制御が実現されます。<br>
 * このパッケージが提供するクラスの種類は主に以下の2つのカテゴリに分類されます。<br>
 * </p>
 * <ul>
 * <li>トランザクション状態管理クラス</li>
 * <p>
 * トランザクションのオープン、クローズ等の状態を管理するクラス({@link org.phosphoresce.webcore.core.transaction.TransactionManager})及び、
 * それらのオブジェクトを統括的に管理するクラス({@link org.phosphoresce.webcore.core.transaction.TransactionContainer})から構成されます。<br>
 * 各サブトランザクションクラスは{@link org.phosphoresce.webcore.core.transaction.TransactionManager}クラスを継承した制御クラスを作成することで、
 * 統一されたインタフェースを持った制御クラスとなり、他のアドオンモジュールからの共通的なトランザクション利用及び、
 * {@link org.phosphoresce.webcore.core.transaction.TransactionContainer}による複数サブトランザクションクラスの一元管理を実現します。<br>
 * 例えばJDBCを直接利用するトランザクションクラスとO/Rマッパーを利用するトランザクションクラスを利用するモジュールがあった場合、
 * 利用するユーザーは呼び出される末端のフレームワークを意識することなく、{@link org.phosphoresce.webcore.core.transaction.TransactionManager}が
 * 提供するインタフェースのみを利用するに留まります。<br>
 * また、複数の異なるトランザクションクラスを同時に利用した場合でも、{@link org.phosphoresce.webcore.core.transaction.TransactionContainer}によって、
 * 一元的に管理可能となるため、ユーザーのトランザクションに対するオープン、クローズは末端のフレームワークに依存しません。<br>
 * </p>
 * <li>トランザクション処理標準化クラス</li>
 * <p>
 * トランザクション処理を実行するユーザーインタフェース({@link org.phosphoresce.webcore.core.transaction.TransactionUser})、
 * トランザクション処理情報を一元的に保持するコンテキストクラス({@link org.phosphoresce.webcore.core.transaction.TransactionContext})、
 * トランザクション処理をカプセル化するための抽象的なサービスクラス({@link org.phosphoresce.webcore.core.transaction.TransactionService})から構成されます。<br>
 * サブトランザクションフレームワークはこれらを必要に応じて継承、インタフェース拡張を行ったクラスを設けて利用します。<br>
 * </p>
 * </ul>
 * 
 * @author Kitagawa<br>
 *<!--
 * 更新日		更新者			更新内容
 * ----/--/--	Kitagawa		新規作成
 *-->
 */
package org.phosphoresce.webcore.core.transaction;