package org.phosphoresce.webcore.core.servlet;

import java.net.InetAddress;
import java.text.DecimalFormat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.phosphoresce.lib.commons.util.FileUtil;
import org.phosphoresce.webcore.core.ConfigName;
import org.phosphoresce.webcore.core.Configuration;
import org.phosphoresce.webcore.core.Environment;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.config.StringResource;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.slf4j.LoggerFactory;

/**
 * アプリケーション起動サーブレットクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/05	Kitagawa		新規作成
 *-->
 */
public class BootstrapServlet extends HttpServlet {

	/** ロガーオブジェクト */
	private CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/**
	 * コンストラクタ<br>
	 */
	public BootstrapServlet() {
		super();
	}

	/**
	 * サーブレットの初期化処理を実行します。<br>
	 * @throws ServletException 初期化処理に失敗した場合にスローされます
	 * @see javax.servlet.GenericServlet#init()
	 */
	@Override
	public void init() throws ServletException {
		//super.init();
		double startTime = System.currentTimeMillis();
		try {
			// 環境変数オブジェクト初期化
			Environment.setDevelopMode(Boolean.parseBoolean(getInitParameter("develop")));
			Environment.setContentPath(getServletContext().getRealPath("").replace("\\", "/"));
			Environment.setWebinfPath(FileUtil.connectPath(getServletContext().getRealPath(""), "WEB-INF").replace("\\", "/"));
			Environment.setContextPath(getServletContext().getContextPath());
			Environment.setServerHost(InetAddress.getLocalHost().getHostName());
			Environment.setConfigPath(Environment.bindEnv(getInitParameter("config")));

			// 各種環境設定初期化
			Configuration.configure();

			// ロガーオブジェクト再作成
			log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

			// アプリケーション起動完了
			double endTime = System.currentTimeMillis();
			log.output("FCRE00008", Environment.bindEnv(getInitParameter("config")));

			for (String name : Config.getStrings(ConfigName.COMMON_RESOURCE_CONFIG_EXTENDS)) {
				log.output("FCRE00009", Environment.bindEnv(name));
			}
			log.output("FCRE00010", new DecimalFormat("0.000").format((endTime - startTime) / 1000D));

			if (Environment.isDevelopMode()) {
				log.output("FCRE00011");
			}

			// アプリケーション起動完了時間設定
			Environment.setStartedTime(System.currentTimeMillis());

			log.output("FCRE00007");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new ServletException(StringResource.getString("FCRE00025"), e);
		}
	}

	/**
	 * サーブレットの破棄処理を実行します。<br>
	 * @see javax.servlet.Filter#destroy()
	 */
	@Override
	public void destroy() {
		Configuration.destroy();
		log.output("FCRE00012");

		// ログ出力が必要となる為、メッセージリソース開放はBootstrapサーブレット破棄のタイミングとする
		StringResource.destroy();
	}
}
