package org.phosphoresce.webcore.core.exception;

import org.phosphoresce.webcore.core.GlobalConstants;
import org.phosphoresce.webcore.core.config.StringResource;

/**
 * フレームワーク例外最上位クラス<br>
 * <br>
 * フレームワークレベルで発生する全ての例外の最上位に位置するクラスです。<br>
 * フレームワーク内でスローされる例外は全てこのクラスを継承したサブクラスで設計されます。<br>
 * 提供されるコンストラクはメッセージコードを受け取るシグネチャとなり、直接メッセージを定義することが制限されます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public abstract class WebcoreException extends RuntimeException implements GlobalConstants {

	/**
	 * コンストラクタ<br>
	 */
	public WebcoreException() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param cause 例外要因
	 */
	public WebcoreException(String code, Throwable cause) {
		super(StringResource.getString(code), cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param binds 例外メッセージバインドオブジェクト
	 * @param cause 例外要因
	 */
	public WebcoreException(String code, Object[] binds, Throwable cause) {
		super(StringResource.getString(code, binds), cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 */
	public WebcoreException(String code) {
		super(StringResource.getString(code));
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 * @param binds 例外メッセージバインドオブジェクト
	 */
	public WebcoreException(String code, Object[] binds) {
		super(StringResource.getString(code, binds));
	}
}
