package org.phosphoresce.webcore.core.exception;

import org.phosphoresce.webcore.core.GlobalConstants;

/**
 * フレームワーク致命的例外最上位クラス<br>
 * <br>
 * フレームワークレベルで発生する全ての致命的な例外の最上位に位置する例外クラスです。<br>
 * フレームワーク内でスローされる例外は全てこのクラスを継承したサブクラスで設計されます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public abstract class WebcoreCriticalException extends WebcoreException implements GlobalConstants {

	/**
	 * コンストラクタ<br>
	 */
	public WebcoreCriticalException() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param cause 例外要因
	 */
	public WebcoreCriticalException(String code, Throwable cause) {
		super(code, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param binds 例外メッセージバインドオブジェクト
	 * @param cause 例外要因
	 */
	public WebcoreCriticalException(String code, Object[] binds, Throwable cause) {
		super(code, binds, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 */
	public WebcoreCriticalException(String code) {
		super(code);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 * @param binds 例外メッセージバインドオブジェクト
	 */
	public WebcoreCriticalException(String code, Object[] binds) {
		super(code, binds);
	}
}
