package org.phosphoresce.webcore.core.config;

import java.io.Serializable;
import java.util.Properties;

import org.phosphoresce.lib.commons.util.PropertiesUtil;
import org.phosphoresce.lib.commons.util.ResourceUtil;
import org.phosphoresce.lib.commons.util.StringUtil;
import org.phosphoresce.webcore.core.ConfigName;
import org.phosphoresce.webcore.core.exception.WebcoreConfigurationException;

/**
 * MIMEタイプクラス<br>
 * <br>
 * 当クラスはwebcore-mimetypes.properties(webcore-config.propertiesで定義されたリソース)にて定義された内容に依存します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/06	Kitagawa		新規作成
 *-->
 */
public class MIMETypes implements Serializable {

	/** 不明MIME代替タイプ */
	public static final String UNKOWN_MIME_TYPE = "application/octet-stream";

	/** クラスインスタンス */
	private static MIMETypes instance;

	/** プロパティオブジェクト */
	private Properties properties;

	/**
	 * コンストラクタ<br>
	 */
	private MIMETypes() {
		super();
	}

	/**
	 * 指定されたコンテンツパス及び、プロパティリソースからクラスを初期化します。<br>
	 */
	public static synchronized void initialize() {
		try {
			instance = new MIMETypes();
			instance.properties = new Properties();
			for (String value : Config.getStrings(ConfigName.COMMON_RESROUCE_MIME_TYPE, true)) {
				if (!StringUtil.isEmpty(value)) {
					if (ResourceUtil.isExistResource(value)) {
						instance.properties.putAll(PropertiesUtil.load(value));
					}
				}
			}
		} catch (Throwable e) {
			throw new WebcoreConfigurationException("FCRE00024", new Object[] { Config.getString(ConfigName.COMMON_RESROUCE_MIME_TYPE) }, e);
		}
	}

	/**
	 * クラスを破棄します。<br>
	 */
	public static synchronized void destroy() {
		if (instance != null) {
			if (instance.properties != null) {
				instance.properties.clear();
			}
		}
		instance = null;
	}

	/**
	 * 指定された拡張子のMIMEタイプを取得します。<br>
	 * 未対応の拡張子の場合はapplication/octet-streamを返却します。<br>
	 * @param extension 拡張子
	 * @return MIMEタイプ文字列
	 */
	public static String getMIMEType(String extension) {
		if (instance == null) {
			return UNKOWN_MIME_TYPE;
		}
		String value = instance.properties.getProperty(extension);
		return StringUtil.isEmpty(value) ? UNKOWN_MIME_TYPE : value;
	}
}
