package org.phosphoresce.webcore.core.test;

import org.phosphoresce.webcore.core.Configuration;
import org.phosphoresce.webcore.core.Environment;

/**
 * テスト上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/07/04	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractTest {

	/**
	 * 初期化処理を行います。<br>
	 * @throws Throwable 予期せぬ例外が発生した場合にスローされます
	 */
	public final void setUp() throws Throwable {
		Configuration.configure(true);
		Environment.setStartedTime(System.currentTimeMillis());
	}

	/**
	 * 終了処理を行います。<br>
	 * @throws Throwable 予期せぬ例外が発生した場合にスローされます
	 */
	public final void setDown() throws Throwable {
		Configuration.destroy();
	}

	/**
	 * テスト処理を行います。<br>
	 * @throws Throwable 予期せぬ例外が発生した場合にスローされます
	 */
	public abstract void process() throws Throwable;

	/**
	 * テスト処理を実行します。<br>
	 * @throws Throwable 予期せぬ例外が発生した場合にスローされます
	 */
	public final void execute() throws Throwable {
		try {
			setUp();
			process();
		} catch (Throwable e) {
			throw e;
		} finally {
			setDown();
		}
	}
}
