/**
 * jQuery拡張スクリプト<br>
 * <br>
 * jQuery標準スクリプトライブラリ拡張インタフェースを提供します。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var JQueryExtends = function() {
};

(function($) {
	/**
	 * 1.9以降で非対応となったbrowserプロパティパッチ
	 */
	if (!$.browser) {
		$.browser = {};
		$.browser.mozilla = /mozilla/.test(navigator.userAgent.toLowerCase()) && !/webkit/.test(navigator.userAgent.toLowerCase());
		$.browser.webkit = /webkit/.test(navigator.userAgent.toLowerCase());
		$.browser.opera = /opera/.test(navigator.userAgent.toLowerCase());
		$.browser.msie = /msie/.test(navigator.userAgent.toLowerCase());
	}

	/**
	 * イベントハンドラを既に登録されているイベントよりも先頭順序にバインドします。<br>
	 * @param {String} イベントタイプ
	 * @param {Function} イベントファンクション
	 * @returns {Object} jQueryオブジェクト
	 * @see http://dev.worksap.co.jp/Members/nogunogu/2010/11/19/jquery-prependeventhander/
	 */
	$.fn.bindAtFirst = function(type, fn) {
		return this.each(function() {
			var funcs = (jQuery.data(this, "events") || {})[type];
			var copyOfFuncs = new Array();
			for ( var i in funcs) {
				var func = funcs[i];
				if (typeof func !== "function") {
					// for jQuery1.4.3
					func = func.handler;
				} else {
					// for jQuery1.3.2
					func.guid = null;
				}
				copyOfFuncs.push(func);
			}
			var $self = $(this);
			$self.unbind(type);
			$self.bind(type, fn);
			for ( var i = 0, l = copyOfFuncs.length; i < l; i++) {
				$self.bind(type, copyOfFuncs[i]);
			}
		});
	};
})(jQuery);
