/**
 * 標準Windowオブジェクト拡張クラス<br>
 * <br>
 * Javascript標準Windowオブジェクトの拡張クラスです。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var WindowEx = function() {
};

var STR_ALERT_DIALOG_TITLE = "内部エラー";
var FLG_JSSTACKTRACE_ENABLED = true;

/**
 * [Windowクラス拡張]<br>
 * アラートダイアログを表示します。<br>
 * 標準のwindow.alertを上書きした関数として提供します。<br>
 * 当処理はjQuery.Deferredによる直列処理を再現しますが、これは複数のダイアログ表示が行われた際に順序を保証するのみです。<br>
 * ダイアログ後の処理同期を保証する場合は当メソッドが返却するDeferredオブジェクトを利用する必要があることに注意して下さい。<br>
 * @param {String} alertMessage アラートメッセージ
 * @returns {Object} 直列処理用Deferredオブジェクト
 */
window._alert = window.alert;
window._alertDefer = null;
window.alert = function(message) {
	try {
		if (window._alertDefer == null) {
			window._alertDefer = Dialog.alert(message);
		} else {
			var newDefer = $.Deferred();
			window._alertDefer.done(function() {
				Dialog.alert(message, newDefer);
			});
			window._alertDefer = newDefer;
		}
	} catch (e) {
		window._alert(e);
	}
	return window._alertDefer;
};
