/**
 * ブラウザ関連操作クラス<br>
 * <br>
 * ブラウザに対する各種操作クラスです。<br>
 * ウィンドウサイズ操作等のブラウザページに対するインタフェースも提供されます。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var Browser = function() {
};

/**
 * ブラウザウィンドウサイズを設定します。<br>
 * 通常ウィンドウ、ダイアログ表示を考慮した設定処理を実施します。<br>
 * @param {Number} width ウィンドウ幅(ピクセル)
 * @param {Number} height ウィンドウ高さ(ピクセル)
 * @returns {Boolean} 正常終了した場合はtrueを返却
 */
Browser.setWindowSize = function(width, height) {
	if (window.dialogWidth) {
		window.dialogWidth = width + "px";
		return true;
	}
	if (window.dialogHeight) {
		window.dialogHeight = height + "px";
		return true;
	}
	if (!window.dialogWidth && !window.dialogHeight) {
		window.resizeTo(width, height);
		return true;
	}
	return false;
};

/**
 * ウィンドウ位置を設定します。<br>
 * 通常ウィンドウ、ダイアログ表示を考慮した設定処理を実施します。<br>
 * @param {Number} top ウィンドウ上部位置(ピクセル)
 * @param {Number} left ウィンドウ左部位置(ピクセル)
 * @returns {Boolean} 正常終了した場合はtrueを返却
 */
Browser.setWindowLocation = function(top, left) {
	if (window.dialogLeft) {
		window.dialogLeft = left + "px";
		return true;
	}
	if (window.dialogTop) {
		window.dialogTop = top + "px";
		return true;
	}
	if (!window.dialogLeft && !window.dialogTop) {
		window.moveTo(left, top);
		return true;
	}
	return false;
};

/**
 * ウィンドウ位置を中央に設定します。<br>
 * 通常ウィンドウ、ダイアログ表示を考慮した設定処理を実施します。<br>
 * @returns {Boolean} 正常終了した場合はtrueを返却
 */
Browser.setWindowCenter = function() {
	var width = $(window).width();
	var height = $(window).height();
	var left = (screen.width - width) / 2;
	var top = (screen.height - height) / 2;
	this.setWindowLocation(top, left);
	return true;
};

/**
 * ブラウザユーザエージェント名を取得します。<br>
 * @returns {String} ブラウザユーザエージェント名
 */
Browser.getBrowserAgentName = function() {
	var userAgent = window.navigator.userAgent;
	if (userAgent) {
		return userAgent;
	} else {
		return "";
	}
};

/**
 * ブラウザ名称を取得します。<br>
 * 返却するブラウザ名は次のうちいずれかとなります。<br>
 * "InternetExplorer"、"Firefox"、"Opera"、"Chrome"、"Safari"、その他UserAgent名。<br>
 * @returns {String} ブラウザ名称
 */
Browser.getBrowserName = function() {
	var userAgent = this.getBrowserAgentName().toLowerCase();
	if (userAgent.indexOf("msie") > -1) {
		return "InternetExplorer";
	} else if (userAgent.indexOf("firefox") > -1) {
		return "Firefox";
	} else if (userAgent.indexOf("opera") > -1) {
		return "Opera";
	} else if (userAgent.indexOf("chrome") > -1) {
		return "Chrome";
	} else if (userAgent.indexOf("safari") > -1) {
		return "Safari";
	} else {
		//return "Unknown";
		return userAgent;
	}
};

/**
 * InternetExplorerのバージョンを取得します。<br>
 * InternetExplorer以外のブラウザの場合は-1を返却します。<br>
 * @returns {Number} InternetExplorerのバージョン
 */
Browser.getIEVersion = function() {
	var userAgent = this.getBrowserAgentName().toLocaleLowerCase();
	if (userAgent.indexOf("msie") > -1) {
		var version = 3;
		var div = document.createElement("div");
		while (div.innerHTML = "<!--[if gt IE " + (++version) + "]><i></i><![endif]-->", div.getElementsByTagName("i")[0]) {
			//
		}
		return version > 4 ? version : 0;
	} else {
		return -1;
	}
};

/**
 * 自身のウィンドウクローズ時のブラウザ警告を発生させずにウィンドウを閉じます。<br>
 * @param {Object} options 動作オプション<br>
 * <ul>
 * <li>beforeClose : ウィンドウクローズ前ファンクション( function ({Object} returnValue) {})
 * </ul>
 * @returns {Boolean} 正常終了した場合はtrueを返却
 */
Browser.closeWindow = function(options) {
	options = !options ? {} : options;

	if (!window.returnValue) {
		window.returnValue = {};
	}

	/*
	 * ウィンドウクローズ前ファンクション実行
	 */
	if (options.beforeClose) {
		options.beforeClose(window.returnValue);
	}

	/*
	 * ウィンドウクローズ
	 */
	(window.open("", "_top").opener = top).close();

	return true;
};

/**
 * 自身のウィンドを前面にフォーカスします。<br>
 * @returns {Boolean} 正常終了した場合はtrueを返却
 */
Browser.focusWindow = function() {
	(window.open("", "_top").opener = top).focus();

	return true;
};
