package org.phosphoresce.lib.commons.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/**
 * 配列ユーティリティ<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/26	Kitagawa		新規作成
 *-->
 */
public class ArrayUtil {

	/**
	 * コンストラクタ<br>
	 */
	private ArrayUtil() {
		super();
	}

	/**
	 * 指定された配列をリストインスタンスとして提供します。<br>
	 * @param objects 変換対象オブジェクト配列
	 * @return 変換されたリストオブジェクト
	 */
	public static <E> List<E> asList(E[] objects) {
		if (objects == null) {
			return new LinkedList<E>();
		}
		List<E> list = new LinkedList<E>();
		for (E e : objects) {
			list.add(e);
		}
		return list;
	}

	/**
	 * リストオブジェクトを配列として提供します。<br>
	 * @param list リストオブジェクト
	 * @return 配列
	 */
	public static String[] toArray(List<String> list) {
		if (list == null) {
			return new String[0];
		}
		return list.toArray(new String[0]);
	}

	/**
	 * 指定されたオブジェクト配列に含まれるオブジェクトであるか判定します。<br>
	 * @param objects オブジェクト配列
	 * @param object オブジェクト
	 * @return 配列に含まれる場合にtrueを返却
	 */
	public static boolean contains(Object[] objects, Object object) {
		if (objects == null) {
			return false;
		}
		return contains(Arrays.asList(objects), object);
	}

	/**
	 * 指定されたオブジェクトリストに含まれるオブジェクトであるか判定します。<br>
	 * @param objects オブジェクトリスト
	 * @param object オブジェクト
	 * @return 配列に含まれる場合にtrueを返却
	 */
	private static boolean contains(List<Object> objects, Object object) {
		if (objects == null) {
			return false;
		}
		for (Object o : objects) {
			if (o == null) {
				if (object == null) {
					return true;
				} else {
					if (object.equals(o)) {
						return true;
					}
				}
			} else {
				if (o.equals(object)) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 指定された開始/終了の連続した数字配列を生成します。<br>
	 * @param start 開始値
	 * @param end 終了値
	 * @param step 加算ステップ
	 * @return 数字配列
	 */
	public static Integer[] createStepedArray(Integer start, Integer end, Integer step) {
		if (step == 0) {
			throw new IllegalArgumentException("step");
		}
		List<Integer> list = new LinkedList<Integer>();
		for (int i = start; i <= end; i += step) {
			list.add(i);
		}
		return list.toArray(new Integer[0]);
	}

	/**
	 * 指定された配列に要素を追加します。<br>
	 * @param arrays 配列
	 * @param value 要素
	 * @return 追加された配列
	 */
	public static Integer[] add(Integer[] arrays, Integer value) {
		List<Integer> list = asList(arrays);
		list.add(value);
		return list.toArray(new Integer[0]);
	}
}
