package org.phosphoresce.commons.wpoi.test;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;

import org.phosphoresce.commons.wpoi.PoiWorkbookType;
import org.phosphoresce.commons.wpoi.adapter.PoiSheet;
import org.phosphoresce.commons.wpoi.adapter.PoiWorkbook;
import org.phosphoresce.commons.wpoi.dyna.PoiDynaExporter;
import org.phosphoresce.commons.wpoi.dyna.PoiDynaList;
import org.phosphoresce.commons.wpoi.dyna.PoiDynaMap;
import org.phosphoresce.commons.wpoi.dyna.PoiDynaObject;
import org.phosphoresce.commons.wpoi.dyna.PoiDynaValueSetter;

public class Test02 implements TestGlobal {

	public static final String TEST_EXCEL_NAME = "Test02Excel.xls";

	public static void main(String[] args) throws Throwable {
		PoiWorkbook workbook = new PoiWorkbook(PoiWorkbookType.EXCEL2003, System.class.getResourceAsStream(TEST_EXCEL_PATH + TEST_EXCEL_NAME));
		PoiSheet sheet = workbook.getSheet(0);

		PoiDynaExporter exporter = new PoiDynaExporter(workbook);

		PoiDynaMap dynaMap = new PoiDynaMap();
		dynaMap.put("companyName", new PoiDynaObject("株式会社○○○○○"));
		dynaMap.put("establishmentDate", new PoiDynaObject(new SimpleDateFormat("yyyy/MM/dd").parse("1994/10/01")));
		dynaMap.put("capitalAmount", new PoiDynaObject(new BigDecimal(1456000000L)));
		dynaMap.put("employeeCount", new PoiDynaObject(2560));

		PoiDynaList sections = new PoiDynaList();
		sections.add(createSection(3, 2));
		sections.add(createSection(1, 1));
		sections.add(createSection(5, 3));
		dynaMap.put("sections", sections);

		exporter.addExportSheet(0, "テスト", dynaMap);
		exporter.export(TEST_EXCEL_NAME);
	}

	private static PoiDynaList createSubSection(int subSectionCount) {
		PoiDynaList list = new PoiDynaList();
		for (int i = 1; i <= subSectionCount; i++) {
			PoiDynaMap map = new PoiDynaMap();
			map.put("subSectionName", new PoiDynaObject(i + "課"));
			list.add(map);
		}
		return list;
	}

	private static PoiDynaList createMainSection(int mainSectionCount, int subSectionCount) {
		PoiDynaList list = new PoiDynaList();
		for (int i = 1; i <= mainSectionCount; i++) {
			PoiDynaMap map = new PoiDynaMap();
			map.put("mainSectionName", new PoiDynaObject(i + "部"));
			map.put("subSections", createSubSection(subSectionCount));
			list.add(map);
		}
		return list;
	}

	private static PoiDynaMap createSection(int mainSectionCount, int subSectionCount) {
		PoiDynaMap map = new PoiDynaMap();
		map.put("mainSections", createMainSection(mainSectionCount, subSectionCount));
		return map;
	}
}
