package org.phosphoresce.commons.wpoi.adapter;

import org.apache.poi.ss.usermodel.Cell;

/**
 * セルクラス<br>
 * <br>
 * POIオブジェクトインタフェースの拡張及び、関連インスタンスへのアクセッサを提供します。<br>
 * また、Excel上でのオペレーションに類似したインタフェースを併せて提供します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2005/11/21	Kitagawa		新規作成
 * 2012/07/09	Kitagawa		バージョン2にアップデート
 *-->
 */
public class PoiCell extends PoiBaseCell {

	/**
	 * コンストラクタ<br>
	 * @param workbook ワークブックオブジェクト
	 * @param sheet シートオブジェクト
	 * @param row 行オブジェクト
	 * @param poiCell セルオブジェクト
	 */
	PoiCell(PoiWorkbook workbook, PoiSheet sheet, PoiRow row, Cell poiCell) {
		super(workbook, sheet, row, poiCell);
	}

	/**
	 * セルのコピーを行います。<br>
	 * @param sheetIndex コピー先シートインデックス(0～)
	 * @param rowIndex コピー先行位置(0～)
	 * @param colIndex コピー先列位置(0～)
	 */
	public void copy(int sheetIndex, int rowIndex, int colIndex) {
		// コピー先オブジェクト取得
		PoiCell dest = workbook.getSheet(sheetIndex).getCell(rowIndex, colIndex);

		// 基本設定コピー
		dest.getPoiCell().setCellType(poiCell.getCellType());
		if (poiCell.getCellStyle() != null) {
			dest.getPoiCell().setCellStyle(poiCell.getCellStyle());
		}
		if (poiCell.getCellComment() != null) {
			dest.getPoiCell().setCellComment(poiCell.getCellComment());
		}
		if (poiCell.getHyperlink() != null) {
			dest.getPoiCell().setHyperlink(poiCell.getHyperlink());
		}

		// コピー処理
		if (Cell.CELL_TYPE_BLANK == poiCell.getCellType()) {
			// CELL_TYPE_BLANKセルタイプのみの設定とする
		} else if (Cell.CELL_TYPE_BOOLEAN == poiCell.getCellType()) {
			dest.getPoiCell().setCellValue(poiCell.getBooleanCellValue());
		} else if (Cell.CELL_TYPE_ERROR == poiCell.getCellType()) {
			dest.getPoiCell().setCellErrorValue(poiCell.getErrorCellValue());
		} else if (Cell.CELL_TYPE_FORMULA == poiCell.getCellType()) {
			dest.getPoiCell().setCellFormula(poiCell.getCellFormula());
		} else if (Cell.CELL_TYPE_NUMERIC == poiCell.getCellType()) {
			dest.getPoiCell().setCellValue(poiCell.getNumericCellValue());
		} else if (Cell.CELL_TYPE_STRING == poiCell.getCellType()) {
			dest.getPoiCell().setCellValue(poiCell.getStringCellValue());
		}
	}

	/**
	 * セルのコピーを行います。<br>
	 * @param sheetName コピー先シート名
	 * @param rowIndex コピー先行位置(0～)
	 * @param colIndex コピー先列位置(0～)
	 */
	public void copy(String sheetName, int rowIndex, int colIndex) {
		copy(workbook.getSheet(sheetName).getSheetIndex(), rowIndex, colIndex);
	}

	/**
	 * セルのコピーを行います。<br>
	 * @param rowIndex コピー先行位置(0～)
	 * @param colIndex コピー先列位置(0～)
	 */
	public void copy(int rowIndex, int colIndex) {
		copy(sheet.getSheetIndex(), rowIndex, colIndex);
	}
}
