package org.phosphoresce.commons.wpoi.adapter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.Region;
import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * POI䃆[eBeBNXB<br>
 * org.apache.poi.hssf̐ƎȃC^tF[X̕⋭ړĨA_v^NXS
 * gp邱ƂړIƂ[eBeB\bhS񋟂B<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 *-->
 */
final class PoiUtil {

	/**
	 * w肳ꂽHSSFCellm̕ʏsB<br>
	 * Zm̃Zl^Cvyђl̕ʂ݂̂sB<br>
	 * ʐyѕʌnullŖƂOB<br>
	 * @param cellFrom ʌHSSFCellIuWFNg
	 * @param cellTo ʐHSSFCellIuWFNg
	 */
	public static void copyCell(HSSFCell cellFrom, HSSFCell cellTo) {
		cellTo.setCellType(cellFrom.getCellType());
		cellTo.setCellStyle(cellFrom.getCellStyle());

		if (HSSFCell.CELL_TYPE_BLANK == cellFrom.getCellType()) {
			cellTo.setCellValue("");
		} else if (HSSFCell.CELL_TYPE_BOOLEAN == cellFrom.getCellType()) {
			cellTo.setCellValue(cellFrom.getBooleanCellValue());
		} else if (HSSFCell.CELL_TYPE_ERROR == cellFrom.getCellType()) {
			cellTo.setCellErrorValue(cellFrom.getErrorCellValue());
		} else if (HSSFCell.CELL_TYPE_FORMULA == cellFrom.getCellType()) {
			cellTo.setCellFormula(cellFrom.getCellFormula());
		} else if (HSSFCell.CELL_TYPE_NUMERIC == cellFrom.getCellType()) {
			cellTo.setCellValue(cellFrom.getNumericCellValue());
		} else if (HSSFCell.CELL_TYPE_STRING == cellFrom.getCellType()) {
			cellTo.setCellValue(cellFrom.getStringCellValue());
		}
	}

	/**
	 * w肳ꂽHSSFRowm̕ʏsB<br>
	 * w肳ꂽHSSFRowɊ܂܂ZIuWFNg̕ʋyэs̕ʏsB<br>
	 * @param rowFrom ʌHSSFRowIuWFNg
	 * @param rowTo ʐHSSFRowIuWFNg
	 */
	public static void copyRow(HSSFRow rowFrom, HSSFRow rowTo) {
		short maxCellNum = rowFrom.getLastCellNum() < rowTo.getLastCellNum() ? rowTo.getLastCellNum() : rowFrom.getLastCellNum();

		for (short i = 0; i <= maxCellNum; i++) {
			HSSFCell cellFrom = rowFrom.getCell(i);
			HSSFCell cellTo = rowTo.getCell(i);

			if (cellFrom != null && cellTo != null) {
				copyCell(cellFrom, cellTo);
			} else if (cellFrom == null && cellTo != null) {
				rowTo.removeCell(cellTo);
			} else if (cellFrom != null && cellTo == null) {
				rowTo.createCell(i);

				cellTo = rowTo.getCell(i);

				copyCell(cellFrom, cellTo);
			}
		}

		rowTo.setHeight(rowFrom.getHeight());
	}

	/**
	 * w肳ꂽ2RegionIuWFNg̗̈ł邩𔻒肵܂B<br>
	 * IuWFNgnbVłȂꍇł̈񂪓ꍇ͓Ƃ݂Ȃ܂B<br>
	 * @param region1 rRegionIuWFNg
	 * @param region2 rRegionIuWFNg
	 * @return ̗̈RegionIuWFNg̏ꍇtrueԋp
	 */
	public static boolean isEqualsRegion(Region region1, Region region2) {
		return region1.getColumnFrom() == region2.getColumnFrom() //
				&& region1.getColumnTo() == region2.getColumnTo() //
				&& region1.getRowFrom() == region2.getRowFrom() //
				&& region1.getRowTo() == region1.getRowTo() //
				&& region1.getArea() == region1.getArea();
	}

	/**
	 * w肳ꂽsʒuAJʒu܂ތŽ܂B<br>
	 * w肵ʒuɂÂ̌Z̈ꕔ܂܂Ȃꍇ͉s܂B<br>
	 * @param sheet ΏۂHSSFSheetIuWFNg
	 * @param row sʒu
	 * @param col Jʒu
	 */
	public static void clearMargedRegion(HSSFSheet sheet, int row, short col) {
		for (int i = 0; i <= sheet.getNumMergedRegions() - 1; i++) {
			Region region = sheet.getMergedRegionAt(i);

			if (row >= region.getRowFrom() && row <= region.getRowTo() && col >= region.getColumnFrom() && col <= region.getColumnTo()) {
				sheet.removeMergedRegion(i);
			}
		}
	}

	/**
	 * w肳ꂽPoiRangeIuWFNgɊ܂܂錋ŽSĉ܂B<br>
	 * PoiRange͈̔͂ɌZ̈ꕔł܂܂ꍇ͂̌ZΏۂƂ܂B<br>
	 * @param sheet ΏۂHSSFSheetIuWFNg
	 * @param range ͈PoiRangeIuWFNg
	 */
	public static void clearMargedRegions(HSSFSheet sheet, PoiRange range) {
		for (int i = range.getRowFrom(); i <= range.getRowTo(); i++) {
			for (short j = range.getColFrom(); j <= range.getColTo(); j++) {
				clearMargedRegion(sheet, i, j);
			}
		}
	}

	/**
	 * w肳ꂽsʒuAJʒǔZIuWFNg擾܂B<br>
	 * @param sheet ΏۂHSSFSheetIuWFNg
	 * @param row sʒu
	 * @param col Jʒu
	 * @return sʒuAJʒuɑ݂錋ZIuWFNg
	 */
	public static Region getMargedRegion(HSSFSheet sheet, int row, short col) {
		for (int i = 0; i <= sheet.getNumMergedRegions() - 1; i++) {
			Region region = sheet.getMergedRegionAt(i);

			if (row >= region.getRowFrom() && row <= region.getRowTo() && col >= region.getColumnFrom() && col <= region.getColumnTo()) {
				return region;
			}
		}

		return null;
	}

	/**
	 * w肳ꂽPoiRangeIuWFNgɊ܂܂錋ZIuWFNgSĎ擾܂B<br>
	 * PoiRange͈̔͂ɌZ̈ꕔł܂܂ꍇ͂̌Z擾ΏۂƂ܂B<br>
	 * @param sheet ΏۂHSSFSheetIuWFNg
	 * @param range 擾͈PoiRangeIuWFNg
	 * @return PoiRange͈̔͂Ɋ܂܂錋ZIuWFNgS
	 */
	public static Region[] getMargedRegions(HSSFSheet sheet, PoiRange range) {
		LinkedList buffer = new LinkedList();

		for (int i = range.getRowFrom(); i <= range.getRowTo(); i++) {
			for (short j = range.getColFrom(); j <= range.getColTo(); j++) {
				Region region = getMargedRegion(sheet, i, j);

				if (region != null) {
					boolean isContain = false;
					for (int c = 0; c <= buffer.size() - 1; c++) {
						Region r = (Region) buffer.get(c);
						if (isEqualsRegion(r, region)) {
							isContain = true;
						}
					}
					if (!isContain) {
						buffer.add(region);
					}
				}
			}
		}

		Region[] regions = new Region[buffer.size()];
		for (int i = 0; i <= buffer.size() - 1; i++) {
			regions[i] = (Region) buffer.get(i);
		}

		return regions;
	}

	/**
	 * w肳ꂽt(yyyyMMdd܂yyyy/MM/dd݂̂)DateIuWFNgƂĎ擾܂B<br>
	 * @param value t(yyyyMMdd܂yyyy/MM/dd݂̂)
	 * @return DateIuWFNg
	 * @throws PoiException sȓtw肵ꍇɔ
	 */
	public static Date parseDate(String value) throws PoiException {
		SimpleDateFormat formatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");
		SimpleDateFormat formatYYYYsMMsDD = new SimpleDateFormat("yyyy/MM/dd");

		Date date = null;

		try {
			date = formatYYYYMMDD.parse(value);
		} catch (ParseException e) {
			try {
				date = formatYYYYsMMsDD.parse(value);
			} catch (ParseException e1) {
				throw new PoiException("ΉĂtϊyyyyMMdd܂yyyy/MM/dd݂̂ł");
			}
		}

		return date;
	}
}
