package org.phosphoresce.commons.socket.http.container;

import org.phosphoresce.commons.socket.http.container.HttpSocketHeader;

import junit.framework.TestCase;

/**
 * TODO クラス説明。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/14	Kitagawa		新規作成
 *-->
 */
public class TestHttpSocketHeader extends TestCase {

	public void testConstructor01() {
		HttpSocketHeader header = new HttpSocketHeader();
		assertEquals("", header.getName());
		assertEquals("", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("", header.getHeaderString());
	}

	public void testConstructor02() {
		HttpSocketHeader header = new HttpSocketHeader("foo", "bar");
		assertEquals("foo", header.getName());
		assertEquals("bar", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("foo: bar", header.getHeaderString());
	}

	public void testSetHeaderString01() {
		HttpSocketHeader header = new HttpSocketHeader();
		header.setHeaderString("foo: bar");
		assertEquals("foo", header.getName());
		assertEquals("bar", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("foo: bar", header.getHeaderString());
	}

	public void testSetHeaderString02() {
		HttpSocketHeader header = new HttpSocketHeader();
		header.setHeaderString("foo");
		assertEquals("foo", header.getName());
		assertEquals("", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("foo:", header.getHeaderString());
	}

	public void testSetHeaderString03() {
		HttpSocketHeader header = new HttpSocketHeader();
		header.setHeaderString(null);
		assertEquals("", header.getName());
		assertEquals("", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("", header.getHeaderString());
	}

	public void testSetName01() {
		HttpSocketHeader header = new HttpSocketHeader();
		header.setName("foo");
		assertEquals("foo", header.getName());
		assertEquals("", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("foo:", header.getHeaderString());
	}

	public void testSetValue01() {
		HttpSocketHeader header = new HttpSocketHeader();
		header.setValue("bar");
		assertEquals("", header.getName());
		assertEquals("bar", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("", header.getHeaderString());
	}

	public void testSetValue02() {
		HttpSocketHeader header = new HttpSocketHeader();
		header.setName("foo");
		header.setValue("bar");
		assertEquals("foo", header.getName());
		assertEquals("bar", header.getValue());
		assertEquals(-1, header.getValueOfInteger());
		assertEquals("foo: bar", header.getHeaderString());
	}
}
