package org.phosphoresce.commons.socket.http.container;

import org.phosphoresce.commons.socket.http.container.HttpSocketCookie;

import junit.framework.TestCase;

/**
 * TODO クラス説明。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/14	Kitagawa		新規作成
 *-->
 */
public class TestHttpSocketCookie extends TestCase {

	public void testConstructor01() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		assertEquals("", cookie.getName());
		assertEquals("", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testConstructor02() {
		HttpSocketCookie cookie = new HttpSocketCookie("foo", "bar");
		assertEquals("foo", cookie.getName());
		assertEquals("bar", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("foo=bar", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testConstructor03() {
		try {
			HttpSocketCookie cookie = new HttpSocketCookie("secure", "bar");
			fail();
		} catch (IllegalArgumentException e) {
		}
	}

	public void testSetCookieString01() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setCookieString("foo=bar");
		assertEquals("foo", cookie.getName());
		assertEquals("bar", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("foo=bar", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testSetCookieString02() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setCookieString("foo");
		assertEquals("foo", cookie.getName());
		assertEquals("", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("foo", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testSetCookieString03() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setCookieString(null);
		assertEquals("", cookie.getName());
		assertEquals("", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testSetCookieString04() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		try {
			cookie.setCookieString("expires=foo");
			fail();
		} catch (IllegalArgumentException e) {
		}
		assertEquals("", cookie.getName());
		assertEquals("", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testSetName01() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setName("foo");
		assertEquals("foo", cookie.getName());
		assertEquals("", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("foo", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testSetValue01() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setValue("bar");
		assertEquals("", cookie.getName());
		assertEquals("bar", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testSetValue02() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setName("foo");
		cookie.setValue("bar");
		assertEquals("foo", cookie.getName());
		assertEquals("bar", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("foo=bar", cookie.getCookieString());
		assertEquals("", cookie.getOption("hoge"));
	}

	public void testSetOption01() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setName("foo");
		cookie.setValue("bar");
		cookie.setOption("hoge", "hogehoge");
		assertEquals("foo", cookie.getName());
		assertEquals("bar", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("foo=bar; hoge=hogehoge", cookie.getCookieString());
		assertEquals("hogehoge", cookie.getOption("hoge"));
	}

	public void testSetOption02() {
		HttpSocketCookie cookie = new HttpSocketCookie();
		cookie.setName("");
		cookie.setValue("bar");
		cookie.setOption("hoge", "hogehoge");
		assertEquals("", cookie.getName());
		assertEquals("bar", cookie.getValue());
		assertEquals(-1, cookie.getValueOfInteger());
		assertEquals("", cookie.getCookieString());
		assertEquals("hogehoge", cookie.getOption("hoge"));
	}
}
