package org.phosphoresce.commons.mail.test;

import java.io.File;
import java.util.Date;

import javax.mail.Address;

import org.phosphoresce.commons.mail.MailAddressContainer;
import org.phosphoresce.commons.mail.MailConfiguration;
import org.phosphoresce.commons.mail.MailContent;
import org.phosphoresce.commons.mail.MailMessage;
import org.phosphoresce.commons.mail.MailSendTransaction;
import org.phosphoresce.commons.mail.configure.MailSMTPConfiguration;
import org.phosphoresce.commons.mail.exception.MailException;
import org.phosphoresce.commons.mail.mail.MailUtil;

/**
 * SMTP[MeXgB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 *-->
 */
public class TestSMTPMailSend extends TestMailAbstract {

	/** eXgpSMTPT[o[ */
	private static final String TEST_SERVER = "127.0.0.1";

	/** eXgpSMTP[U[ */
	private static final String TEST_USER = "";

	/** eXgpSMTPpX[h */
	private static final String TEST_PASSWORD = "";

	/** eXgpAhX */
	private static final String TEST_ADDRESS = "";

	/** eXgpO */
	private static final String TEST_NAME = "";

	/** eXgpYtt@C */
	private static final String TEST_ATTACH = "";

	/**
	 * C\bhB<br>
	 * @param args R}hC
	 * @throws Exception sɗ\ʃG[X[ꂽꍇɔ
	 */
	public static void main(String[] args) throws Exception {

		// ڑIuWFNgyуgUNVIuWFNg
		MailSMTPConfiguration configuration = new MailSMTPConfiguration(TEST_SERVER, TEST_USER, TEST_PASSWORD);
		MailSendTransaction transaction = new MailSendTransaction(configuration);

		// ǂݎpƂăgUNVJn
		transaction.begin(true);

		// bZ[WIuWFNg̐
		MailMessage message = createTestMessage(configuration);

		// bZ[W̃g[X
		traceMessage(message);

		// [M
		transaction.send(message);

		// gUNVN[Y
		transaction.close();
	}

	/**
	 * eXg[bZ[WIuWFNg𐶐܂B<br>
	 * @param configuration ݒIuWFNg
	 * @return eXg[bZ[WIuWFNg
	 * @throws MailException ɃeXg[bZ[W̐sȂꍇɔ
	 */
	private static MailMessage createTestMessage(MailConfiguration configuration) throws MailException {
		// e탁[AhX
		Address from = MailUtil.createMailAddress(TEST_ADDRESS, TEST_NAME);
		Address to = MailUtil.createMailAddress(TEST_ADDRESS, TEST_NAME);
		Address cc = MailUtil.createMailAddress(TEST_ADDRESS, TEST_NAME);
		Address bcc = MailUtil.createMailAddress(TEST_ADDRESS, TEST_NAME);

		// MAhX񐶐
		MailAddressContainer container = new MailAddressContainer();
		container.addRecipientTo(from);
		container.addRecipientTo(to);
		container.addRecipientCc(cc);
		container.addRecipientBcc(bcc);

		// [Rec
		MailContent content = new MailContent();
		content.setSubject("MeXg[");
		content.setContent("<font color=\"#0000ff\">MeXg[</font>");
		content.setHTML(true);
		content.addAttachResource(new File(TEST_ATTACH));

		MailMessage message = new MailMessage(configuration, container, content, new Date());
		message.save(new File("C:\\Temp\\Test.eml"));

		return message;
	}
}
