package org.phosphoresce.commons.eswing;

import java.awt.Component;

import javax.swing.JScrollPane;

import org.phosphoresce.commons.eswing.core.ESwingComponent;
import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * JScrollPanegNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class EScrollPane extends JScrollPane implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
		setOpaque(true);
		setWheelScrollingEnabled(true);
		setAutoscrolls(true);

		getVerticalScrollBar().setUnitIncrement(15);
		getHorizontalScrollBar().setUnitIncrement(15);

		setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	}

	/**
	 * RXgN^<br>
	 * @see JScrollPane#JScrollPane()
	 */
	public EScrollPane() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param view Viewportɐݒ肳ComponentIuWFNg
	 * @param vsbPolicy XN[o[̃|V[w肷鐮^
	 * @param hsbPolicy XN[o[̃|V[w肷鐮^
	 * @see JScrollPane#JScrollPane(Component, int, int)
	 */
	public EScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
		super(view, vsbPolicy, hsbPolicy);
		dressup();

		setHorizontalScrollBarPolicy(hsbPolicy);
		setVerticalScrollBarPolicy(vsbPolicy);
	}

	/**
	 * RXgN^<br>
	 * @param view Viewportɐݒ肳ComponentIuWFNg
	 * @see JScrollPane#JScrollPane(Component)
	 */
	public EScrollPane(Component view) {
		super(view);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param vsbPolicy XN[o[̃|V[w肷鐮^
	 * @param hsbPolicy XN[o[̃|V[w肷鐮^
	 * @see JScrollPane#JScrollPane(int, int)
	 */
	public EScrollPane(int vsbPolicy, int hsbPolicy) {
		super(vsbPolicy, hsbPolicy);
		dressup();

		setHorizontalScrollBarPolicy(hsbPolicy);
		setVerticalScrollBarPolicy(vsbPolicy);
	}
}
