package org.phosphoresce.commons.eswing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import javax.swing.JTable;

import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * e[uZzo[F_NX<br>
 * NX͕\R|[lĝ̍쐬͒񋟂Aw肳ꂽʃ_IuWFNgɈϏ܂B<br>
 * NXɏʂ̃_IuWFNgw肳Ȃꍇ̓fBtHg_gp܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public class ETableCellHoverColoredRenderer extends ETableCellStepColoredRenderer implements MouseMotionListener {

	/** zo[J[OtO */
	private boolean hoverColoring = true;

	/** }EX|Cgsʒu */
	private int pointedRow = -1;

	/** }EX|Cgʒu */
	private int pointedCol = -1;

	/**
	 * RXgN^<br>
	 * @param table JTableIuWFNg
	 * @param hoverColoring zo[J[OtO
	 */
	public ETableCellHoverColoredRenderer(JTable table, boolean hoverColoring) {
		super(table);
		this.hoverColoring = hoverColoring;
		table.addMouseMotionListener(this);
	}

	/**
	 * RXgN^<br>
	 * @param table JTableIuWFNg
	 */
	public ETableCellHoverColoredRenderer(JTable table) {
		this(table, true);
	}

	/**
	 * sʒũIuWFNg̕\R|[lg񋟂܂B<br>
	 * @param table JTableIuWFNg
	 * @param value lIuWFNg
	 * @param isSelected ItO
	 * @param hasFocus tH[JXtO
	 * @param row sʒu
	 * @param column ʒu
	 * @return ComponentIuWFNg
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

		Color background = super.getBackground();
		Color foreground = super.getForeground();

		if (hoverColoring) {
			if (!hasFocus && !isSelected) {
				if (hoverColoring) {
					if (pointedRow == row) {
						background = ESwingConfig.getTableHoverCellBackgroundColor();
						foreground = ESwingConfig.getTableHoverCellForegroungColor();
					}
				} else {
					if (pointedRow == row && pointedCol == column) {
						background = ESwingConfig.getTableHoverCellBackgroundColor();
						foreground = ESwingConfig.getTableHoverCellForegroungColor();
					}
				}
			}
			setBackground(background);
			setForeground(foreground);
		}

		return this;
	}

	/**
	 * e[ũ}EXړ̃Cxg܂B<br>
	 * @param e CxgIuWFNg
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e) {
		Point point = e.getPoint();

		int nrow = getParentTable().rowAtPoint(point);
		int ncol = getParentTable().columnAtPoint(point);

		if (nrow < 0 || ncol < 0) {
			pointedRow = -1;
			pointedCol = -1;
		} else {
			pointedRow = nrow;
			pointedCol = ncol;
		}

		getParentTable().repaint();
	}

	/**
	 * e[ũ}EXhbÕCxg܂B<br>
	 * @param e CxgIuWFNg
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e) {
		//
	}

	/**
	 * zo[J[OtO擾܂B<br>
	 * @return zo[J[OtO
	 */
	public boolean isHoverColoring() {
		return hoverColoring;
	}

	/**
	 * zo[J[OtOݒ肵܂B<br>
	 * @param hoverColoring zo[J[OtO
	 */
	public void setHoverColoring(boolean hoverColoring) {
		this.hoverColoring = hoverColoring;
	}
}
