package org.phosphoresce.commons.eswing.core;

import java.awt.Component;
import java.util.Iterator;

import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

import org.phosphoresce.commons.eswing.exception.ESwingComponentIllegalStateException;

/**
 * gSwingR|[lgeݒ}l[WNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public final class ESwingConfigManager {

	/**
	 * RXgN^<br>
	 */
	private ESwingConfigManager() {
		super();
	}

	/**
	 * ESwingConfig񋟂SĂ̏Swingɑ΂Ĕf܂B<br>
	 */
	public static void configure() {
		configureLookAndFeel();
		configureFont();
		configureIcons();
	}

	/**
	 * ESwingConfig񋟂ACRSwingɑ΂Ĕf܂B<br>
	 */
	public static void configureIcons() {
		UIDefaults defaults = UIManager.getLookAndFeelDefaults();
		defaults.put("FileChooser.detailsViewIcon", ESwingConfig.getFilechooserDetailsViewIcon());
		defaults.put("FileChooser.listViewIcon", ESwingConfig.getFilechooserListViewIcon());
		defaults.put("FileChooser.newFolderIcon", ESwingConfig.getFilechooserNewFolderIcon());
		defaults.put("FileChooser.upFolderIcon", ESwingConfig.getFilechooserUpFolderIcon());
	}

	/**
	 * ESwingConfig񋟂FontSwingɑ΂Ĕf܂B<br>
	 */
	public static void configureFont() {
		FontUIResource containerFont = new FontUIResource(ESwingConfig.getContainerFont());
		FontUIResource passwordFont = new FontUIResource(ESwingConfig.getPasswordFont());
		UIDefaults defaults = UIManager.getLookAndFeelDefaults();
		for (Iterator iterator = defaults.keySet().iterator(); iterator.hasNext();) {
			Object key = iterator.next();
			if (key.toString().toLowerCase().endsWith("font")) {
				if (key.toString().toLowerCase().indexOf("password") >= 0) {
					UIManager.put(key, passwordFont);
				} else {
					UIManager.put(key, containerFont);
				}
			}
		}
	}

	/**
	 * ESwingConfig񋟂Look&FeelSwingɑ΂Ĕf܂B<br>
	 */
	public static void configureLookAndFeel() {
		try {
			UIManager.setLookAndFeel(ESwingConfig.getLookAndFeelName());
		} catch (Exception e1) {
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} catch (Exception e2) {
				throw new ESwingComponentIllegalStateException("failed to apply look and feel", e1);
			}
		}
	}

	/**
	 * w肳ꂽComponentIuWFNgyєz̃IuWFNgɑ΂āA
	 * ESwingConfig񋟂Look&FeelKp܂B<br>
	 * @param component ΏComponentIuWFNg
	 */
	public static void updateLookAndFeel(Component component) {
		configureLookAndFeel();
		SwingUtilities.updateComponentTreeUI(component);
	}

	/**
	 * w肳ꂽComponentIuWFNgyєz̃IuWFNgɑ΂āA
	 * ESwingConfig񋟂FontKp܂B<br>
	 * @param component ΏComponentIuWFNg
	 */
	public static void updateFont(Component component) {
		configureFont();
		SwingUtilities.updateComponentTreeUI(component);
	}
}
