package org.phosphoresce.commons.util;

import junit.framework.TestCase;

/**
 * StringUtilクラステストケース<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/06	Kitagawa		新規作成
 *-->
 */
public class TestStringUtil extends TestCase {

	public void testIsEmpy() throws Throwable {
		assertEquals(StringUtil.isEmpty(null), true);
		assertEquals(StringUtil.isEmpty(""), true);
		assertEquals(StringUtil.isEmpty(" "), false);
		assertEquals(StringUtil.isEmpty("\n"), false);
	}

	public void testIsAscii() throws Throwable {
		assertEquals(StringUtil.isAscii(null), true);
		assertEquals(StringUtil.isAscii(""), true);
		assertEquals(StringUtil.isAscii("foo"), true);
		assertEquals(StringUtil.isAscii("あ"), false);
		assertEquals(StringUtil.isAscii("fooあ"), false);

		assertEquals(StringUtil.isAscii('a'), true);
		assertEquals(StringUtil.isAscii('あ'), false);
	}

	public void testIsDigit() throws Throwable {
		assertEquals(StringUtil.isDigit(null), false);
		assertEquals(StringUtil.isDigit(""), false);
		assertEquals(StringUtil.isDigit(" "), false);
		assertEquals(StringUtil.isDigit(" 0 "), false);
		assertEquals(StringUtil.isDigit("0"), true);
		assertEquals(StringUtil.isDigit("0.1"), true);
		assertEquals(StringUtil.isDigit("+0.1"), true);
		assertEquals(StringUtil.isDigit("-0.1"), true);
		assertEquals(StringUtil.isDigit("-0.1"), true);
	}

	public void testIsNumeric() throws Throwable {
		assertEquals(StringUtil.isNumeric(null), true);
		assertEquals(StringUtil.isNumeric(""), true);
		assertEquals(StringUtil.isNumeric(" "), false);
		assertEquals(StringUtil.isNumeric(" 0 "), false);
		assertEquals(StringUtil.isNumeric("0"), true);
		assertEquals(StringUtil.isNumeric("0.1"), false);
		assertEquals(StringUtil.isNumeric("+0.1"), false);
		assertEquals(StringUtil.isNumeric("-0.1"), false);
		assertEquals(StringUtil.isNumeric("-0.1"), false);

		char[] ex = new char[] { '.', '+', '-' };
		assertEquals(StringUtil.isNumeric(null, ex), true);
		assertEquals(StringUtil.isNumeric("", ex), true);
		assertEquals(StringUtil.isNumeric(" ", ex), false);
		assertEquals(StringUtil.isNumeric(" 0 ", ex), false);
		assertEquals(StringUtil.isNumeric("0", ex), true);
		assertEquals(StringUtil.isNumeric("0.1", ex), true);
		assertEquals(StringUtil.isNumeric("+0.1", ex), true);
		assertEquals(StringUtil.isNumeric("-0.1", ex), true);
		assertEquals(StringUtil.isNumeric("-0.1", ex), true);
	}

	public void testIsAplphabet() throws Throwable {
		assertEquals(StringUtil.isAlphabet(null), true);
		assertEquals(StringUtil.isAlphabet(""), true);
		assertEquals(StringUtil.isAlphabet(" "), false);
		assertEquals(StringUtil.isAlphabet(" A "), false);
		assertEquals(StringUtil.isAlphabet("ABCabc"), true);
		assertEquals(StringUtil.isAlphabet("ABC1abc"), false);
		assertEquals(StringUtil.isAlphabet("+ABC"), false);

		char[] ex = new char[] { '+', '1' };
		assertEquals(StringUtil.isAlphabet(null), true);
		assertEquals(StringUtil.isAlphabet("", ex), true);
		assertEquals(StringUtil.isAlphabet(" ", ex), false);
		assertEquals(StringUtil.isAlphabet(" A ", ex), false);
		assertEquals(StringUtil.isAlphabet("ABCabc", ex), true);
		assertEquals(StringUtil.isAlphabet("ABC1abc", ex), true);
		assertEquals(StringUtil.isAlphabet("+ABC", ex), true);
	}

	public void testIsAplphaNumeric() throws Throwable {
		assertEquals(StringUtil.isAlphaNumeric(null), true);
		assertEquals(StringUtil.isAlphaNumeric(""), true);
		assertEquals(StringUtil.isAlphaNumeric(" "), false);
		assertEquals(StringUtil.isAlphaNumeric(" A1 "), false);
		assertEquals(StringUtil.isAlphaNumeric("ABC1abc"), true);
		assertEquals(StringUtil.isAlphaNumeric("+ABC"), false);

		char[] ex = new char[] { '+' };
		assertEquals(StringUtil.isAlphaNumeric(null), true);
		assertEquals(StringUtil.isAlphaNumeric("", ex), true);
		assertEquals(StringUtil.isAlphaNumeric(" ", ex), false);
		assertEquals(StringUtil.isAlphaNumeric(" A1 ", ex), false);
		assertEquals(StringUtil.isAlphaNumeric("ABC1abc", ex), true);
		assertEquals(StringUtil.isAlphaNumeric("+ABC", ex), true);
	}

	public void testIsValidCharacers() throws Throwable {
		char[] valid = new char[] { '+', '-' };
		assertEquals(StringUtil.isValidCharacers(null, valid), true);
		assertEquals(StringUtil.isValidCharacers("", valid), true);
		assertEquals(StringUtil.isValidCharacers(" ", valid), false);
		assertEquals(StringUtil.isValidCharacers(" +- ", valid), false);
		assertEquals(StringUtil.isValidCharacers("+-+-+-+-", valid), true);
	}

	public void testEquals() throws Throwable {
		assertEquals(StringUtil.equals(null, null), true);
		assertEquals(StringUtil.equals("", ""), true);
		assertEquals(StringUtil.equals(null, ""), false);
		assertEquals(StringUtil.equals("", null), false);
		assertEquals(StringUtil.equals("A", "B"), false);
		assertEquals(StringUtil.equals("ABC123あ～", "ABC123あ～"), true);
		assertEquals(StringUtil.equals("ABC123あ～", "abc123あ～"), false);
	}

	public void testEqualsIgnoreCase() throws Throwable {
		assertEquals(StringUtil.equalsIgnoreCase(null, null), true);
		assertEquals(StringUtil.equalsIgnoreCase("", ""), true);
		assertEquals(StringUtil.equalsIgnoreCase(null, ""), false);
		assertEquals(StringUtil.equalsIgnoreCase("", null), false);
		assertEquals(StringUtil.equalsIgnoreCase("A", "B"), false);
		assertEquals(StringUtil.equalsIgnoreCase("ABC123あ～", "ABC123あ～"), true);
		assertEquals(StringUtil.equalsIgnoreCase("ABC123あ～", "abc123あ～"), true);
	}

	public void testContains() throws Throwable {
		String[] strings = new String[] { "foo", "bar" };
		assertEquals(StringUtil.contains(strings, "foo"), true);
		assertEquals(StringUtil.contains(strings, "bar"), true);
		assertEquals(StringUtil.contains(strings, "hoge"), false);
		assertEquals(StringUtil.contains(strings, "FOO"), false);
		assertEquals(StringUtil.contains(strings, "BAR"), false);
		assertEquals(StringUtil.contains(strings, ""), false);
		assertEquals(StringUtil.contains(strings, null), false);
	}

	public void testContainsIgnoreCase() throws Throwable {
		String[] strings = new String[] { "foo", "bar" };
		assertEquals(StringUtil.containsIgnoreCase(strings, "foo"), true);
		assertEquals(StringUtil.containsIgnoreCase(strings, "bar"), true);
		assertEquals(StringUtil.containsIgnoreCase(strings, "hoge"), false);
		assertEquals(StringUtil.containsIgnoreCase(strings, "FOO"), true);
		assertEquals(StringUtil.containsIgnoreCase(strings, "BAR"), true);
		assertEquals(StringUtil.containsIgnoreCase(strings, ""), false);
		assertEquals(StringUtil.containsIgnoreCase(strings, null), false);
	}

	public void testPaddingChar() throws Throwable {
		assertEquals(StringUtil.paddingChar("foo", 5, ' ', true), "  foo");
		assertEquals(StringUtil.paddingChar("foo", 5, ' ', false), "foo  ");
		assertEquals(StringUtil.paddingChar("foo", 1, ' ', true), "foo");
		assertEquals(StringUtil.paddingChar("foo", 1, ' ', false), "foo");
		assertEquals(StringUtil.paddingChar("ああ", 5, ' ', true), " ああ");
		assertEquals(StringUtil.paddingChar("ああ", 5, ' ', false), "ああ ");
		assertEquals(StringUtil.paddingChar("ああ", 3, ' ', true), "ああ");
		assertEquals(StringUtil.paddingChar("ああ", 3, ' ', false), "ああ");
	}

	public void testSupplyByte() throws Throwable {
		assertEquals(StringUtil.supplyByte("foo", -1, "MS932", ' ', true), "foo");
		assertEquals(StringUtil.supplyByte("foo", 3, "MS932", ' ', true), "foo");
		assertEquals(StringUtil.supplyByte("foo", 5, "MS932", ' ', true), "  foo");
		assertEquals(StringUtil.supplyByte("あああ", 5, "MS932", ' ', true), "あああ");
		assertEquals(StringUtil.supplyByte("ああ", 5, "MS932", ' ', true), " ああ");
		assertEquals(StringUtil.supplyByte("ああ", 6, "UTF-8", ' ', true), "ああ");
		assertEquals(StringUtil.supplyByte("ああ", 7, "UTF-8", ' ', true), " ああ");
		assertEquals(StringUtil.supplyByte("ああ", 5, "Shift_JIS", ' ', true), " ああ");
	}

	public void testSubstr() throws Throwable {
		assertEquals(StringUtil.substr(null, 0, 0), null);
		assertEquals(StringUtil.substr("", 0, 0), "");
		assertEquals(StringUtil.substr("", 10, 10), "");
		assertEquals(StringUtil.substr("", -10, -10), "");
		assertEquals(StringUtil.substr("foo", 0, 3), "foo");
		assertEquals(StringUtil.substr("foo", 0, 5), "foo");
		assertEquals(StringUtil.substr("foo", 1, 5), "oo");
		assertEquals(StringUtil.substr("foo", 5, 10), "");
		assertEquals(StringUtil.substr("foo", 2, 2), "o");
		assertEquals(StringUtil.substr("foo", 2, 1), "o");
		assertEquals(StringUtil.substr("foo", 2, 0), "");
		assertEquals(StringUtil.substr("foo", 2, -1), "");
	}

	public void testSubstrb() throws Throwable {
		assertEquals(StringUtil.substrb(null, 0, 0, null), null);
		assertEquals(StringUtil.substrb("", 0, 0, null), "");
		assertEquals(StringUtil.substrb("", 10, 10, null), "");
		assertEquals(StringUtil.substrb("", -10, -10, null), "");
		assertEquals(StringUtil.substrb("foo", 0, 3, null), "foo");
		assertEquals(StringUtil.substrb("foo", 0, 5, null), "foo");
		assertEquals(StringUtil.substrb("foo", 1, 5, null), "oo");
		assertEquals(StringUtil.substrb("foo", 5, 10, null), "");
		assertEquals(StringUtil.substrb("foo", 2, 2, null), "o");
		assertEquals(StringUtil.substrb("foo", 2, 1, null), "o");
		assertEquals(StringUtil.substrb("foo", 2, 0, null), "");
		assertEquals(StringUtil.substrb("foo", 2, -1, null), "");

		assertEquals(StringUtil.substrb("ああ", 0, 1, null), " ");
		assertEquals(StringUtil.substrb("ああ", 0, 2, null), "あ");
		assertEquals(StringUtil.substrb("ああ", 1, 2, null), "  ");
		assertEquals(StringUtil.substrb("ああ", 1, 3, null), " あ");

		assertEquals(StringUtil.substrb("あaあ", 0, 1, null), " ");
		assertEquals(StringUtil.substrb("あaあ", 0, 2, null), "あ");
		assertEquals(StringUtil.substrb("あaあ", 1, 2, null), " a");
		assertEquals(StringUtil.substrb("あaあ", 1, 3, null), " a ");
	}
}
