package org.phosphoresce.commons.io;

import java.io.ByteArrayOutputStream;

import junit.framework.TestCase;

/**
 * ReplacableOutputStreamクラステストケース<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/06	Kitagawa		新規作成
 *-->
 */
public class TestReplacableOutputStream extends TestCase {

	public void testWriteNoMatch() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "foo", "bar");

		replacableStream.write("abcdefg".getBytes());
		replacableStream.flush();

		assertEquals("abcdefg", new String(nativeStream.toByteArray()));
	}

	public void testWriteMatch() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "foo", "bar");

		replacableStream.write("foobarfoobarfoo".getBytes());
		replacableStream.flush();

		assertEquals("barbarbarbarbar", new String(nativeStream.toByteArray()));
	}

	public void testWriteReplaceToEmpty() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "(foo|bar)", "", true, 3);

		replacableStream.write("foobarfoobarfoo".getBytes());
		replacableStream.flush();

		assertEquals("", new String(nativeStream.toByteArray()));
	}

	public void testWriteReplaceToNull() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "(foo|bar)", null, true, 3);

		replacableStream.write("foobarfoobarfoo".getBytes());
		replacableStream.flush();

		assertEquals("", new String(nativeStream.toByteArray()));
	}

	public void testWriteEmpty() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "", "");

		replacableStream.write("foobarfoobarfoo".getBytes());
		replacableStream.flush();

		assertEquals("foobarfoobarfoo", new String(nativeStream.toByteArray()));
	}

	public void testWriteNull() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, null, null);

		replacableStream.write("foobarfoobarfoo".getBytes());
		replacableStream.flush();

		assertEquals("foobarfoobarfoo", new String(nativeStream.toByteArray()));
	}

	public void testWriteReplaceOverLength() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "foo", "foooo");

		replacableStream.write("foobarfoobarfoo".getBytes());
		replacableStream.flush();

		assertEquals("foooobarfoooobarfoooo", new String(nativeStream.toByteArray()));
	}

	public void testWriteReplaceUnderLength() throws Throwable {
		ByteArrayOutputStream nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "foo", "f");

		replacableStream.write("foobarfoobarfoo".getBytes());
		replacableStream.flush();

		assertEquals("fbarfbarf", new String(nativeStream.toByteArray()));
	}

	public void testSpeed1K() throws Throwable {
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i <= 1024; i++) {
			buffer.append("B");
		}

		ByteArrayOutputStream nativeStream = null;

		long time = System.currentTimeMillis();

		nativeStream = new ByteArrayOutputStream();
		nativeStream.write(buffer.toString().getBytes());
		nativeStream.flush();
		long normal = System.currentTimeMillis() - time;

		nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "BBBBBBBB", "AAAAAAAA");
		replacableStream.write(buffer.toString().getBytes());
		replacableStream.flush();
		long replacable = System.currentTimeMillis() - time;

		//System.out.println(new String(nativeStream.toByteArray()));
		System.out.println("normal : " + normal + " / replacable : " + replacable + " (" + ((double) buffer.toString().getBytes().length / 1024 / 1024) + "MB)");
	}

	public void testSpeed1M() throws Throwable {
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i <= 1024 * 1024; i++) {
			buffer.append("B");
		}

		ByteArrayOutputStream nativeStream = null;

		long time = System.currentTimeMillis();

		nativeStream = new ByteArrayOutputStream();
		nativeStream.write(buffer.toString().getBytes());
		nativeStream.flush();
		long normal = System.currentTimeMillis() - time;

		nativeStream = new ByteArrayOutputStream();
		ReplacableOutputStream replacableStream = new ReplacableOutputStream(nativeStream, "BBBBBBBB", "AAAAAAAA");
		replacableStream.write(buffer.toString().getBytes());
		replacableStream.flush();
		long replacable = System.currentTimeMillis() - time;

		//System.out.println(new String(nativeStream.toByteArray()));
		System.out.println("normal : " + normal + " / replacable : " + replacable + " (" + ((double) buffer.toString().getBytes().length / 1024 / 1024) + "MB)");
	}
}

