package org.phosphoresce.commons.html;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML.Tag;

/**
 * HTMLタグクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/19	Kitagawa		新規作成
 *-->
 */
public class HTMLTagElement extends HTMLDocumentElement {

	/** タグ名 */
	private String name;

	/** 属性情報 */
	private Map attribute;

	/**
	 * コンストラクタ<br>
	 */
	public HTMLTagElement() {
		super();
		this.name = null;
		this.attribute = new HashMap();
	}

	/**
	 * コンストラクタ<br>
	 * @param name タグ名
	 */
	public HTMLTagElement(String name) {
		super();
		this.name = name;
		this.attribute = new HashMap();
	}

	/**
	 * コンストラクタ<br>
	 * @param tag javax.swing.text.html.HTML.Tagオブジェクト
	 * @param attribute javax.swing.text.AttributeSetオブジェクト
	 */
	public HTMLTagElement(Tag tag, AttributeSet attribute) {
		super();
		this.name = tag.toString();
		this.attribute = new HashMap();
		for (Enumeration enumeration = attribute.getAttributeNames(); enumeration.hasMoreElements();) {
			Object key = enumeration.nextElement();
			String name = key.toString();
			String value = attribute.getAttribute(key) == null ? null : attribute.getAttribute(key).toString();
			this.attribute.put(name, value);
		}
	}

	/**
	 * エレメントが子エレメントの操作をサポートしているか判定します。<br>
	 * @return HTMLTagは子エレメントをサポートするためtrueを返却
	 * @see org.phosphoresce.commons.html.HTMLElement#isSupportChild()
	 */
	public boolean isSupportChild() {
		return true;
	}

	/**
	 * タグ名を取得します。<br>
	 * @return タグ名
	 */
	public String getName() {
		return name == null ? "" : name;
	}

	/**
	 * タグ名を設定します。<br>
	 * @param name タグ名
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 属性情報を設定します。<br>
	 * @param name 属性名
	 * @param value 属性値
	 */
	public void setAttribute(String name, String value) {
		attribute.put(name, value);
	}

	/**
	 * 属性情報を取得します。<br>
	 * @param name 属性名
	 * @return 属性値
	 */
	public String getAttribute(String name) {
		String value = (String) attribute.get(name);
		return value == null ? "" : value;
	}

	/**
	 * 属性情報を削除します。<br>
	 * @param name 属性名
	 */
	public void removeAttribute(String name) {
		attribute.remove(name);
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("name=");
		buffer.append(name);
		buffer.append(",");
		buffer.append("attribute=");
		buffer.append(attribute);
		buffer.append(",");
		buffer.append("childs=");
		buffer.append(getChilds());
		buffer.append("}");
		return buffer.toString();
	}
}

