package org.phosphoresce.socket.proxy.http.handler;

import java.net.Socket;

import org.phosphoresce.commons.socket.http.container.HttpSocketRequest;
import org.phosphoresce.socket.proxy.http.config.HttpReverseProxyConfig;
import org.phosphoresce.socket.proxy.http.session.HttpReverseProxyControllerSession;
import org.phosphoresce.socket.proxy.http.session.HttpReverseProxyServerSession;

/**
 * HTTPリバースプロキシクライアントリクエスト補正ハンドラークラス<br>
 * <br>
 * 当ハンドラクラスは以下の仕様で動作させることを想定しています。<br>
 * <b>前提</b>
 * ・コントローラーセッションにクライアントソケットオブジェクトが設定されていること<br>
 * ・コントローラーセッションにクライアントリクエスト情報が設定されていること<br>
 * <br>
 * <b>処理</b>
 * リクエスト転送するためのクライアントリクエスト情報を補正<br>
 * <br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/17	Kitagawa		新規作成
 *-->
 */
public class RequestValidateHandler extends HttpReverseProxyHandlerAdapter {

	/**
	 * コンストラクタ<br>
	 * @param serverSession サーバーセッションオブジェクト
	 * @param controllerSession コントローラーセッションオブジェクト
	 */
	public RequestValidateHandler(HttpReverseProxyServerSession serverSession, HttpReverseProxyControllerSession controllerSession) {
		super(serverSession, controllerSession);
	}

	/**
	 * イベントハンドル処理を実行します。<br>
	 * @return イベントハンドル処理後、プロキシコントローラーの後続処理を実施する場合にtrueを返却
	 * @throws Throwable 正常にイベントハンドル処理が行えなかった場合にスローされます
	 * @see org.phosphoresce.socket.proxy.http.handler.HttpReverseProxyHandler#execute()
	 */
	public boolean execute() throws Throwable {
		// 共通フィールド取得
		HttpReverseProxyConfig config = HttpReverseProxyConfig.instance();
		HttpReverseProxyServerSession serverSession = getServerSession();
		HttpReverseProxyControllerSession controllerSession = getControllerSession();
		Socket clientSocket = getClientSocket();
		String clientAddress = getClientSocket().getInetAddress().getHostAddress();
		HttpSocketRequest request = getRequest();

		// X-Forwarded-Forヘッダ追加(但し、既に存在する場合は上書きしない)
		if (!request.containsHeader("X-Forwarded-For")) {
			request.addHeader("X-Forwarded-For", clientAddress);
		}

		// レスポンスに転送するためのクライアントリクエスト情報を補正
		// TODO Keep-Alive未対応時にConnectionをcloseにする必要があるか不明(IEにてフリーズすることがあった)
		//		if (request.containsHeader("Connection")) {
		//			String value = request.getHeaderValueOfString("Connection");
		//			request.putHeader("Connection", "close");
		//		}
		// TODO Hostヘッダは置換する必要があるか不明
		//		if (getRequest().containsHeader("Host")) {
		//			String value = getRequest().getHeaderValueOfString("Host");
		//			getRequest().putHeader("Host", getConfig().getServerAddress());
		//		}

		return true;
	}
}
