package org.phosphoresce.socket.proxy.http.config;

import java.io.Serializable;

/**
 * HTTPリバースプロキシリダイレクトマッピング定義クラス<br>
 * <br>
 * 当クラスは特定のURL(正規表現)に合致するリクエストが行われた場合に
 * 他のURLアドレスにリダイレクトする為のマッピング環境を管理します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/08	Kitagawa		新規作成
 *-->
 */
public class RequestRedirectConfig implements Serializable {

	/** マッピング対象URL正規表現 */
	private String matchUrl;

	/** リダイレクトURL */
	private String redirectUrl;

	/**
	 * コンストラクタ<br>
	 */
	public RequestRedirectConfig() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param matchUrl マッピング対象URL正規表現
	 * @param redirectUrl リダイレクトURL
	 */
	public RequestRedirectConfig(String matchUrl, String redirectUrl) {
		super();
		this.matchUrl = matchUrl;
		this.redirectUrl = redirectUrl;
	}

	/**
	 * マッピング対象URL正規表現を取得します。<br>
	 * @return マッピング対象URL正規表現
	 */
	public String getMatchUrl() {
		return matchUrl;
	}

	/**
	 * マッピング対象URL正規表現を設定します。<br>
	 * @param matchUrl マッピング対象URL正規表現
	 */
	public void setMatchUrl(String matchUrl) {
		this.matchUrl = matchUrl;
	}

	/**
	 * リダイレクトURLを取得します。<br>
	 * @return リダイレクトURL
	 */
	public String getRedirectUrl() {
		return redirectUrl;
	}

	/**
	 * リダイレクトURLを設定します。<br>
	 * @param redirectUrl リダイレクトURL
	 */
	public void setRedirectUrl(String redirectUrl) {
		this.redirectUrl = redirectUrl;
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("matchUrl=");
		buffer.append(matchUrl);
		buffer.append(",");
		buffer.append("redirectUrl=");
		buffer.append(redirectUrl);
		buffer.append("}");
		return buffer.toString();
	}
}
