package org.phosphoresce.dbbrowser.gui.common.window;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;

import javax.swing.DefaultComboBoxModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EComboBox;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EPasswordField;
import org.phosphoresce.commons.eswing.ETextField;
import org.phosphoresce.dbbrowser.DatabaseBrowserConstants;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserConfig;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserConnectionConfig;
import org.phosphoresce.dbbrowser.gui.common.DialogHeaderPanel;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSample;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSampleDefinition;

/**
 * f[^x[Xڑݒ_CAO<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/16	Kitagawa		VK쐬
 * 2007/10/24	Kitagawa		Save^C~OXMLɏo͂悤ɏC
 *-->
 */
public class ConnectionConfigureFrame extends EDialog {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** DatabaseBrowserZbV */
	private DatabaseBrowserSession browserSession = null;

	/** ZtCX^X */
	private ConnectionConfigureFrame instance = null;

	/** Recpl */
	private EPanel contentsPanel = null;

	/** _CAOwb_pl */
	private DialogHeaderPanel dialogHeaderPanel = null;

	/** JDBCݒtB[hZbg */
	private EFieldSet jdbcFieldSet = null;

	/** JDBC`Xgx */
	private ELabel jdbcDefinitionListLabel = null;

	/** JDBC`Xg */
	private EComboBox jdbcDefinitionList = null;

	/** JDBC`x */
	private ELabel jdbcDefinitionNameLabel = null;

	/** JDBC`tB[h */
	private ETextField jdbcDefinitionNameField = null;

	/** JDBCTv`Xgx */
	private ELabel jdbcSampleDefinitionListLabel = null;

	/** JDBC`TvXg */
	private EComboBox jdbcSampleDefinitionList = null;

	/** JDBChCoNXx */
	private ELabel jdbcDriverClassLabel = null;

	/** JDBChCoNXtB[h */
	private ETextField jdbcDriverClassField = null;

	/** JDBCURLNXx */
	private ELabel jdbcUrlLabel = null;

	/** JDBCURLNXtB[h */
	private ETextField jdbcUrlField = null;

	/** JDBC[U[NXx */
	private ELabel jdbcUserLabel = null;

	/** JDBC[U[NXtB[h */
	private ETextField jdbcUserField = null;

	/** JDBCpX[hNXx */
	private ELabel jdbcPasswordLabel = null;

	/** JDBCpX[hNXtB[h */
	private EPasswordField jdbcPasswordField = null;

	/** {^pl */
	private EPanel buttonPanel = null;

	/** {^Xy[T[ */
	private ELabel buttonPanelSpacer = null;

	/** LZ{^ */
	private EButton cancelButton = null;

	/** NA{^ */
	private EButton clearButton = null;

	/** ڑ{^ */
	private EButton connectButton = null;

	/** ۑ{^ */
	private EButton saveButton = null;

	/**
	 * RXgN^<br>
	 * @param frame FrameIuWFNg
	 * @param browserSession DatabaseBrowserZbV
	 */
	public ConnectionConfigureFrame(Frame frame, DatabaseBrowserSession browserSession) {
		super(frame, true);
		this.browserSession = browserSession;
		this.instance = this;

		initialize();

		try {
			DatabaseBrowserConfig config = DatabaseBrowserConfig.instance();
			storeConfig(config.getRecentConnectionConfig().getConnectionConfig().getDatabaseConfig());
			storeConfigList();
			storeSampleConfigList();
		} catch (Throwable throwable) {
			EMessageDialog.showError(instance, "failed to load connection definitions.", throwable);
		}
	}

	/**
	 * vpeBێڑ`Xgɔf܂B<br>
	 */
	private void storeConfigList() {
		try {
			DatabaseBrowserConfig config = DatabaseBrowserConfig.instance();
			DefaultComboBoxModel model = new DefaultComboBoxModel();
			model.addElement("< Recent Connection >");
			for (Iterator iterator = config.getDefinitionedConnectionConfig().getDatabaseConfigDefinitionList().iterator(); iterator.hasNext();) {
				DatabaseBrowserConnectionConfig connectionConfig = (DatabaseBrowserConnectionConfig) iterator.next();
				model.addElement(connectionConfig.getName());
			}
			getJdbcDefinitionList().setModel(model);
		} catch (Throwable throwable) {
			EMessageDialog.showError(instance, "failed to load connection definitions.", throwable);
		}
	}

	/**
	 * vpeBێڑ`Xgɔf܂B<br>
	 */
	private void storeSampleConfigList() {
		try {
			DefaultComboBoxModel model = new DefaultComboBoxModel();
			model.addElement("< Select Sample Definition >");
			for (Iterator iterator = DatabaseBrowserJDBCSample.instance().getSampleDefinitionIterator(); iterator.hasNext();) {
				DatabaseBrowserJDBCSampleDefinition definition = (DatabaseBrowserJDBCSampleDefinition) iterator.next();
				model.addElement(definition.getName());
			}
			getJdbcSampleDefinitionList().setModel(model);
		} catch (Throwable throwable) {
			EMessageDialog.showError(instance, "failed to load sample definitions.", throwable);
		}
	}

	/**
	 * w肳ꂽڑ`IuWFNgtB[hɓe𔽉f܂B<br>
	 * @param config ڑ`IuWFNg
	 */
	private void storeConfig(DatabaseConfig config) {
		if (config != null) {
			getJdbcDriverClassField().setText(config.getJdbcDriver());
			getJdbcUrlField().setText(config.getJdbcUrl());
			getJdbcUserField().setText(config.getJdbcUser());
			getJdbcPasswordField().setText(config.getJdbcPassword());
		} else {
			getJdbcDriverClassField().setText("");
			getJdbcUrlField().setText("");
			getJdbcUserField().setText("");
			getJdbcPasswordField().setText("");
		}
	}

	/**
	 * tB[h̓ef[^x[Xڑ`IuWFNg쐬܂B<br>
	 * @return f[^x[Xڑ`
	 */
	private DatabaseConfig makeConfig() {
		DatabaseConfig config = new DatabaseConfig();
		config.setJdbcDriver(getJdbcDriverClassField().getText());
		config.setJdbcUrl(getJdbcUrlField().getText());
		config.setJdbcUser(getJdbcUserField().getText());
		config.setJdbcPassword(new String(getJdbcPasswordField().getPassword()));
		return config;
	}

	/**
	 * RXgN^<br>
	 */
	private ConnectionConfigureFrame() {
		this(null, null);
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setContentPane(getContentsPanel());
		this.setTitle(DatabaseBrowserConstants.APPLICATION_TITLE);
		this.setLocationRelativeTo(getParent());
		this.setSize(new Dimension(465, 350));

		getRootPane().setDefaultButton(getConnectButton());
	}

	/**
	 * Recpl擾܂B<br>
	 * @return Recpl
	 */
	private EPanel getContentsPanel() {
		if (contentsPanel == null) {
			GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
			gridBagConstraints17.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints17.fill = GridBagConstraints.BOTH;
			gridBagConstraints17.gridx = 0;
			gridBagConstraints17.gridy = 2;
			gridBagConstraints17.weightx = 1.0D;
			gridBagConstraints17.weighty = 1.0D;
			GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
			gridBagConstraints16.insets = new Insets(4, 10, 4, 10);
			gridBagConstraints16.fill = GridBagConstraints.BOTH;
			gridBagConstraints16.gridx = 0;
			gridBagConstraints16.gridy = 1;
			gridBagConstraints16.weightx = 1.0D;
			gridBagConstraints16.weighty = 0.0D;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0D;
			gridBagConstraints1.weighty = 0.0D;
			contentsPanel = new EPanel();
			contentsPanel.setLayout(new GridBagLayout());
			contentsPanel.add(getDialogHeaderPanel(), gridBagConstraints1);
			contentsPanel.add(getJdbcFieldSet(), gridBagConstraints16);
			contentsPanel.add(getButtonPanel(), gridBagConstraints17);
		}
		return contentsPanel;
	}

	/**
	 * _CAOwb_pl擾܂B<br>
	 * @return _CAOwb_pl
	 */
	private DialogHeaderPanel getDialogHeaderPanel() {
		if (dialogHeaderPanel == null) {
			dialogHeaderPanel = new DialogHeaderPanel();
			dialogHeaderPanel.setText("Configure JDBC Connection");
		}
		return dialogHeaderPanel;
	}

	/**
	 * JDBCݒtB[hZbg擾܂B<br>
	 * @return JDBCݒtB[hZbg
	 */
	private EFieldSet getJdbcFieldSet() {
		if (jdbcFieldSet == null) {
			GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
			gridBagConstraints14.fill = GridBagConstraints.BOTH;
			gridBagConstraints14.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints14.gridx = 1;
			gridBagConstraints14.gridy = 6;
			gridBagConstraints14.weightx = 1.0;
			gridBagConstraints14.weighty = 0.0;
			GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
			gridBagConstraints13.fill = GridBagConstraints.BOTH;
			gridBagConstraints13.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints13.gridx = 0;
			gridBagConstraints13.gridy = 6;
			gridBagConstraints13.weightx = 0.0;
			gridBagConstraints13.weighty = 0.0;
			GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
			gridBagConstraints12.fill = GridBagConstraints.BOTH;
			gridBagConstraints12.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints12.gridx = 1;
			gridBagConstraints12.gridy = 5;
			gridBagConstraints12.weightx = 1.0;
			gridBagConstraints12.weighty = 0.0;
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.fill = GridBagConstraints.BOTH;
			gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints11.gridx = 0;
			gridBagConstraints11.gridy = 5;
			gridBagConstraints11.weightx = 0.0;
			gridBagConstraints11.weighty = 0.0;
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.fill = GridBagConstraints.BOTH;
			gridBagConstraints10.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints10.gridx = 1;
			gridBagConstraints10.gridy = 4;
			gridBagConstraints10.weightx = 1.0;
			gridBagConstraints10.weighty = 0.0;
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.fill = GridBagConstraints.BOTH;
			gridBagConstraints9.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints9.gridx = 0;
			gridBagConstraints9.gridy = 4;
			gridBagConstraints9.weightx = 0.0;
			gridBagConstraints9.weighty = 0.0;
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.fill = GridBagConstraints.BOTH;
			gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints8.gridx = 1;
			gridBagConstraints8.gridy = 3;
			gridBagConstraints8.weightx = 1.0;
			gridBagConstraints8.weighty = 0.0;
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.fill = GridBagConstraints.BOTH;
			gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints7.gridx = 0;
			gridBagConstraints7.gridy = 3;
			gridBagConstraints7.weightx = 0.0;
			gridBagConstraints7.weighty = 0.0;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.fill = GridBagConstraints.BOTH;
			gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints6.gridx = 1;
			gridBagConstraints6.gridy = 2;
			gridBagConstraints6.weightx = 1.0;
			gridBagConstraints6.weighty = 0.0;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints5.gridx = 0;
			gridBagConstraints5.gridy = 2;
			gridBagConstraints5.weightx = 0.0;
			gridBagConstraints5.weighty = 0.0;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.fill = GridBagConstraints.BOTH;
			gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints4.gridx = 1;
			gridBagConstraints4.gridy = 1;
			gridBagConstraints4.weightx = 1.0;
			gridBagConstraints4.weighty = 0.0;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints3.gridx = 0;
			gridBagConstraints3.gridy = 1;
			gridBagConstraints3.weightx = 0.0;
			gridBagConstraints3.weighty = 0.0;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.gridy = 0;
			gridBagConstraints2.weightx = 1.0;
			gridBagConstraints2.weighty = 0.0;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 0.0;
			gridBagConstraints1.weighty = 0.0;
			jdbcFieldSet = new EFieldSet();
			jdbcFieldSet.setLayout(new GridBagLayout());
			jdbcFieldSet.setText("JDBC Connection Config");
			jdbcFieldSet.setPreferredSize(new Dimension(436, 211));
			jdbcFieldSet.setMaximumSize(new Dimension(436, 211));
			jdbcFieldSet.setMinimumSize(new Dimension(436, 211));
			jdbcFieldSet.add(getJdbcSampleDefinitionListLabel(), gridBagConstraints1);
			jdbcFieldSet.add(getJdbcSampleDefinitionList(), gridBagConstraints2);
			jdbcFieldSet.add(getJdbcDefinitionListLabel(), gridBagConstraints3);
			jdbcFieldSet.add(getJdbcDefinitionList(), gridBagConstraints4);
			jdbcFieldSet.add(getJdbcDefinitionNameLabel(), gridBagConstraints5);
			jdbcFieldSet.add(getJdbcDefinitionNameField(), gridBagConstraints6);
			jdbcFieldSet.add(getJdbcDriverClassLabel(), gridBagConstraints7);
			jdbcFieldSet.add(getJdbcDriverClassField(), gridBagConstraints8);
			jdbcFieldSet.add(getJdbcUrlLabel(), gridBagConstraints9);
			jdbcFieldSet.add(getJdbcUrlField(), gridBagConstraints10);
			jdbcFieldSet.add(getJdbcUserLabel(), gridBagConstraints11);
			jdbcFieldSet.add(getJdbcUserField(), gridBagConstraints12);
			jdbcFieldSet.add(getJdbcPasswordLabel(), gridBagConstraints13);
			jdbcFieldSet.add(getJdbcPasswordField(), gridBagConstraints14);
		}
		return jdbcFieldSet;
	}

	/**
	 * JDBC`Xgx擾܂B<br>
	 * @return JDBC`Xgx
	 */
	private ELabel getJdbcDefinitionListLabel() {
		if (jdbcDefinitionListLabel == null) {
			jdbcDefinitionListLabel = new ELabel();
			jdbcDefinitionListLabel.setText("Definition List :");
			jdbcDefinitionListLabel.setPreferredSize(new Dimension(120, 22));
			jdbcDefinitionListLabel.setMaximumSize(new Dimension(120, 22));
			jdbcDefinitionListLabel.setMinimumSize(new Dimension(120, 22));
		}
		return jdbcDefinitionListLabel;
	}

	/**
	 * JDBC`Xg擾܂B<br>
	 * @return JDBC`Xg
	 */
	private EComboBox getJdbcDefinitionList() {
		if (jdbcDefinitionList == null) {
			jdbcDefinitionList = new EComboBox();
			jdbcDefinitionList.setPreferredSize(new Dimension(280, 22));
			jdbcDefinitionList.setMaximumSize(new Dimension(280, 22));
			jdbcDefinitionList.setMinimumSize(new Dimension(280, 22));
			jdbcDefinitionList.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					try {
						DatabaseBrowserConfig config = DatabaseBrowserConfig.instance();
						int index = jdbcDefinitionList.getSelectedIndex();
						if (index == 0) {
							storeConfig(config.getRecentConnectionConfig().getConnectionConfig().getDatabaseConfig());
							getJdbcDefinitionNameField().setText("");
						} else {
							DatabaseBrowserConnectionConfig connectionConfig = (DatabaseBrowserConnectionConfig) config.getDefinitionedConnectionConfig()
									.getDatabaseConfigDefinitionList().get(index - 1);
							storeConfig(connectionConfig.getDatabaseConfig());
							getJdbcDefinitionNameField().setText(connectionConfig.getName());
						}
					} catch (Throwable throwable) {
						String errorMessage = "failed to load connection definition.";
						log.error(errorMessage, throwable);
						EMessageDialog.showError(instance, errorMessage, throwable);
					}
				}
			});
		}
		return jdbcDefinitionList;
	}

	/**
	 * JDBC`x擾܂B<br>
	 * @return JDBC`x
	 */
	private ELabel getJdbcDefinitionNameLabel() {
		if (jdbcDefinitionNameLabel == null) {
			jdbcDefinitionNameLabel = new ELabel();
			jdbcDefinitionNameLabel.setText("Definition Name :");
			jdbcDefinitionNameLabel.setPreferredSize(new Dimension(120, 22));
			jdbcDefinitionNameLabel.setMaximumSize(new Dimension(120, 22));
			jdbcDefinitionNameLabel.setMinimumSize(new Dimension(120, 22));
		}
		return jdbcDefinitionNameLabel;
	}

	/**
	 * JDBC`tB[h擾܂B<br>
	 * @return JDBC`tB[h
	 */
	private ETextField getJdbcDefinitionNameField() {
		if (jdbcDefinitionNameField == null) {
			jdbcDefinitionNameField = new ETextField();
			jdbcDefinitionNameField.setPreferredSize(new Dimension(280, 22));
			jdbcDefinitionNameField.setMaximumSize(new Dimension(280, 22));
			jdbcDefinitionNameField.setMinimumSize(new Dimension(280, 22));
		}
		return jdbcDefinitionNameField;
	}

	/**
	 * JDBCTv`Xgx擾܂B<br>
	 * @return JDBCXgx
	 */
	private ELabel getJdbcSampleDefinitionListLabel() {
		if (jdbcSampleDefinitionListLabel == null) {
			jdbcSampleDefinitionListLabel = new ELabel();
			jdbcSampleDefinitionListLabel.setText("Sample Definition :");
			jdbcSampleDefinitionListLabel.setPreferredSize(new Dimension(120, 22));
			jdbcSampleDefinitionListLabel.setMaximumSize(new Dimension(120, 22));
			jdbcSampleDefinitionListLabel.setMinimumSize(new Dimension(120, 22));
		}
		return jdbcSampleDefinitionListLabel;
	}

	/**
	 * JDBCTv`Xg擾܂B<br>
	 * @return JDBC`Xg
	 */
	private EComboBox getJdbcSampleDefinitionList() {
		if (jdbcSampleDefinitionList == null) {
			jdbcSampleDefinitionList = new EComboBox();
			jdbcSampleDefinitionList.setPreferredSize(new Dimension(280, 22));
			jdbcSampleDefinitionList.setMaximumSize(new Dimension(280, 22));
			jdbcSampleDefinitionList.setMinimumSize(new Dimension(280, 22));
			jdbcSampleDefinitionList.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					try {
						if (jdbcSampleDefinitionList.getSelectedIndex() > 0) {
							int index = jdbcSampleDefinitionList.getSelectedIndex() - 1;
							DatabaseBrowserJDBCSampleDefinition definition = DatabaseBrowserJDBCSample.instance().getSampleDefinition(index);
							getJdbcDefinitionNameField().setText("");
							getJdbcDriverClassField().setText(definition.getDriver());
							getJdbcUrlField().setText(definition.getSampleUrl());
							getJdbcUserField().setText("");
							getJdbcPasswordField().setText("");
							jdbcSampleDefinitionList.setSelectedIndex(0);
						}
					} catch (Throwable throwable) {
						String errorMessage = "failed to load connection definition.";
						log.error(errorMessage, throwable);
						EMessageDialog.showError(instance, errorMessage, throwable);
					}
				}
			});
		}
		return jdbcSampleDefinitionList;
	}

	/**
	 * JDBChCoNXx擾܂B<br>
	 * @return JDBChCoNXx
	 */
	private ELabel getJdbcDriverClassLabel() {
		if (jdbcDriverClassLabel == null) {
			jdbcDriverClassLabel = new ELabel();
			jdbcDriverClassLabel.setText("JDBC Driver Class :");
			jdbcDriverClassLabel.setPreferredSize(new Dimension(120, 22));
			jdbcDriverClassLabel.setMaximumSize(new Dimension(120, 22));
			jdbcDriverClassLabel.setMinimumSize(new Dimension(120, 22));
		}
		return jdbcDriverClassLabel;
	}

	/**
	 * JDBChCoNXtB[h擾܂B<br>
	 * @return JDBChCoNXtB[h
	 */
	private ETextField getJdbcDriverClassField() {
		if (jdbcDriverClassField == null) {
			jdbcDriverClassField = new ETextField();
			jdbcDriverClassField.setPreferredSize(new Dimension(280, 22));
			jdbcDriverClassField.setMaximumSize(new Dimension(280, 22));
			jdbcDriverClassField.setMinimumSize(new Dimension(280, 22));
		}
		return jdbcDriverClassField;
	}

	/**
	 * JDBCURLNXx擾܂B<br>
	 * @return JDBCURLNXx
	 */
	private ELabel getJdbcUrlLabel() {
		if (jdbcUrlLabel == null) {
			jdbcUrlLabel = new ELabel();
			jdbcUrlLabel.setText("JDBC URL :");
			jdbcUrlLabel.setPreferredSize(new Dimension(120, 22));
			jdbcUrlLabel.setMaximumSize(new Dimension(120, 22));
			jdbcUrlLabel.setMinimumSize(new Dimension(120, 22));
		}
		return jdbcUrlLabel;
	}

	/**
	 * JDBCURLNXtB[h擾܂B<br>
	 * @return JDBCURLNXtB[h
	 */
	private ETextField getJdbcUrlField() {
		if (jdbcUrlField == null) {
			jdbcUrlField = new ETextField();
			jdbcUrlField.setPreferredSize(new Dimension(280, 22));
			jdbcUrlField.setMaximumSize(new Dimension(280, 22));
			jdbcUrlField.setMinimumSize(new Dimension(280, 22));
		}
		return jdbcUrlField;
	}

	/**
	 * JDBC[U[NXx擾܂B<br>
	 * @return JDBC[U[NXx
	 */
	private ELabel getJdbcUserLabel() {
		if (jdbcUserLabel == null) {
			jdbcUserLabel = new ELabel();
			jdbcUserLabel.setText("JDBC User :");
			jdbcUserLabel.setPreferredSize(new Dimension(120, 22));
			jdbcUserLabel.setMaximumSize(new Dimension(120, 22));
			jdbcUserLabel.setMinimumSize(new Dimension(120, 22));
		}
		return jdbcUserLabel;
	}

	/**
	 * JDBC[U[NXtB[h擾܂B<br>
	 * @return JDBC[U[NXtB[h
	 */
	private ETextField getJdbcUserField() {
		if (jdbcUserField == null) {
			jdbcUserField = new ETextField();
			jdbcUserField.setPreferredSize(new Dimension(280, 22));
			jdbcUserField.setMaximumSize(new Dimension(280, 22));
			jdbcUserField.setMinimumSize(new Dimension(280, 22));
		}
		return jdbcUserField;
	}

	/**
	 * JDBCpX[hNXx擾܂B<br>
	 * @return JDBCpX[hNXx
	 */
	private ELabel getJdbcPasswordLabel() {
		if (jdbcPasswordLabel == null) {
			jdbcPasswordLabel = new ELabel();
			jdbcPasswordLabel.setText("JDBC Password :");
			jdbcPasswordLabel.setPreferredSize(new Dimension(120, 22));
			jdbcPasswordLabel.setMaximumSize(new Dimension(120, 22));
			jdbcPasswordLabel.setMinimumSize(new Dimension(120, 22));
		}
		return jdbcPasswordLabel;
	}

	/**
	 * JDBCpX[hNXtB[h擾܂B<br>
	 * @return JDBCpX[hNXtB[h
	 */
	private EPasswordField getJdbcPasswordField() {
		if (jdbcPasswordField == null) {
			jdbcPasswordField = new EPasswordField();
			jdbcPasswordField.setPreferredSize(new Dimension(280, 22));
			jdbcPasswordField.setMaximumSize(new Dimension(280, 22));
			jdbcPasswordField.setMinimumSize(new Dimension(280, 22));
		}
		return jdbcPasswordField;
	}

	/**
	 * {^pl擾܂B<br>
	 * @return {^pl
	 */
	private EPanel getButtonPanel() {
		if (buttonPanel == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.insets = new Insets(0, 0, 0, 0);
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 0.0D;
			gridBagConstraints.weighty = 0.0D;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.insets = new Insets(0, 4, 0, 0);
			gridBagConstraints1.gridx = 1;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0D;
			gridBagConstraints1.weighty = 1.0D;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.insets = new Insets(0, 4, 0, 0);
			gridBagConstraints2.gridx = 2;
			gridBagConstraints2.gridy = 0;
			gridBagConstraints2.weightx = 0.0D;
			gridBagConstraints2.weighty = 0.0D;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.insets = new Insets(0, 4, 0, 0);
			gridBagConstraints3.gridx = 3;
			gridBagConstraints3.gridy = 0;
			gridBagConstraints3.weightx = 0.0D;
			gridBagConstraints3.weighty = 0.0D;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.insets = new Insets(0, 4, 0, 0);
			gridBagConstraints4.gridx = 4;
			gridBagConstraints4.gridy = 0;
			gridBagConstraints4.weightx = 0.0D;
			gridBagConstraints4.weighty = 0.0D;
			buttonPanel = new EPanel();
			buttonPanel.setLayout(new GridBagLayout());
			buttonPanel.setPreferredSize(new Dimension(400, 36));
			buttonPanel.setMaximumSize(new Dimension(400, 36));
			buttonPanel.setMinimumSize(new Dimension(400, 36));
			buttonPanel.add(getSaveButton(), gridBagConstraints);
			buttonPanel.add(getButtonPanelSpacer(), gridBagConstraints1);
			buttonPanel.add(getConnectButton(), gridBagConstraints2);
			buttonPanel.add(getClearButton(), gridBagConstraints3);
			buttonPanel.add(getCancelButton(), gridBagConstraints4);
		}
		return buttonPanel;
	}

	/**
	 * {^Xy[T[擾܂B<br>
	 * @return {^Xy[T[
	 */
	private ELabel getButtonPanelSpacer() {
		if (buttonPanelSpacer == null) {
			buttonPanelSpacer = new ELabel();
		}
		return buttonPanelSpacer;
	}

	/**
	 * LZ{^擾܂B<br>
	 * @return LZ{^
	 */
	private EButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new EButton();
			cancelButton.setText("Cancel");
			cancelButton.setPreferredSize(new Dimension(86, 24));
			cancelButton.setMaximumSize(new Dimension(86, 24));
			cancelButton.setMinimumSize(new Dimension(86, 24));
			cancelButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					dispose();
				}
			});
		}
		return cancelButton;
	}

	/**
	 * NA{^擾܂B<br>
	 * @return NA{^
	 */
	private EButton getClearButton() {
		if (clearButton == null) {
			clearButton = new EButton();
			clearButton.setText("Clear");
			clearButton.setPreferredSize(new Dimension(86, 24));
			clearButton.setMaximumSize(new Dimension(86, 24));
			clearButton.setMinimumSize(new Dimension(86, 24));
			clearButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					//getJdbcDefinitionList().setSelectedIndex(0);
					getJdbcDefinitionNameField().setText("");
					getJdbcDriverClassField().setText("");
					getJdbcUrlField().setText("");
					getJdbcUserField().setText("");
					getJdbcPasswordField().setText("");
				}
			});
		}
		return clearButton;
	}

	/**
	 * ڑ{^擾܂B<br>
	 * @return ڑ{^
	 */
	private EButton getConnectButton() {
		if (connectButton == null) {
			connectButton = new EButton();
			connectButton.setText("Connect");
			connectButton.setPreferredSize(new Dimension(86, 24));
			connectButton.setMaximumSize(new Dimension(86, 24));
			connectButton.setMinimumSize(new Dimension(86, 24));
			connectButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try {
						DatabaseConfig config = makeConfig();

						new DatabaseSession(config).close();
						browserSession.setConfig(config);

						DatabaseBrowserConfig.instance().getRecentConnectionConfig().setConnectionConfig(config);

						dispose();
					} catch (Throwable throwable) {
						String errorMessage = "failed to connect database.";
						log.error(errorMessage, throwable);
						EMessageDialog.showError(instance, errorMessage, throwable);
					}
				}
			});
		}
		return connectButton;
	}

	/**
	 * ۑ{^擾܂B<br>
	 * @return ۑ{^
	 */
	private EButton getSaveButton() {
		if (saveButton == null) {
			saveButton = new EButton();
			saveButton.setText("Save");
			saveButton.setPreferredSize(new Dimension(86, 24));
			saveButton.setMaximumSize(new Dimension(86, 24));
			saveButton.setMinimumSize(new Dimension(86, 24));
			saveButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try {
						String name = getJdbcDefinitionNameField().getText();
						if ("".equals(name.trim())) {
							EMessageDialog.showError(instance, "definition name is empty.");
						} else {
							if (DatabaseBrowserConfig.instance().getDefinitionedConnectionConfig().containsDatabaseConfig(name)) {
								int result = EMessageDialog.showQuestion(instance, "'" + name + "' is already exist.<br>over write this definition ?");
								if (result != EMessageDialog.BUTTON_YES) {
									return;
								}
							}
							DatabaseBrowserConfig.instance().getDefinitionedConnectionConfig().setDatabaseConfig(name, makeConfig());
							storeConfigList();

							// save configure XML
							DatabaseBrowserConfig.instance().save();
						}
					} catch (Throwable throwable) {
						String errorMessage = "failed to save connection definition.";
						log.error(errorMessage, throwable);
						EMessageDialog.showError(instance, errorMessage, throwable);
					}
				}
			});
		}
		return saveButton;
	}
}
