/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class SocketFactory {
    private SocketFactory() {
    }

    public static SSLContext createServerSocketSSLContext(String keystorePath, String keystorePasswd) throws GeneralSecurityException, IOException {
        char[] keystorePasswdChars = keystorePasswd.toCharArray();
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(new FileInputStream(keystorePath), keystorePasswdChars);
        KeyManagerFactory factory = KeyManagerFactory.getInstance("SunX509");
        factory.init(keystore, keystorePasswdChars);
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(factory.getKeyManagers(), null, null);
        return context;
    }

    public static SSLContext createScoketSSLContext() throws GeneralSecurityException {
        KeyManager[] keymanager = null;
        TrustManager[] trustmanager = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(keymanager, trustmanager, null);
        return context;
    }

    public static SSLSocket createSSLSocket(String address, int port) throws GeneralSecurityException, IOException {
        SSLSocketFactory factory = SocketFactory.createScoketSSLContext().getSocketFactory();
        return (SSLSocket)factory.createSocket(address, port);
    }

    public static SSLServerSocket createSSLServerSocket(int port, String keystorePath, String keystorePasswd) throws GeneralSecurityException, IOException {
        SSLServerSocketFactory factory = SocketFactory.createServerSocketSSLContext(keystorePath, keystorePasswd).getServerSocketFactory();
        return (SSLServerSocket)factory.createServerSocket(port);
    }

    public static SSLSocket createSSLSocket(SSLContext context, String address, int port) throws IOException {
        SSLSocketFactory factory = context.getSocketFactory();
        return (SSLSocket)factory.createSocket(address, port);
    }

    public static SSLServerSocket createSSLServerSocket(SSLContext context, int port) throws IOException {
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        return (SSLServerSocket)factory.createServerSocket(port);
    }

    public static Socket createSocket(String address, int port) throws IOException {
        return new Socket(address, port);
    }

    public static ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }
}

